package com.cku.oa.order.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.Date;

/**
 * @author yuanshuai
 * @date 2023/6/8 15:27
 */
@Data
@ApiModel
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class GoldCertifiedBusinessVo extends OrderBusinessVo {

    private static final long serialVersionUID = -4459362489654240852L;

    @ApiModelProperty("申请来源（1:血统证书升级2:登记卡申请）")
    private Integer applySource;

    @ApiModelProperty("犬只ID")
    private String dogId;

    @ApiModelProperty("血统证书号")
    private String pedigreeCertified;

    @ApiModelProperty("国外证书号")
    private String overseasPedigreeCertified;

    @ApiModelProperty("出生纸编号")
    private String birthCode;

    @ApiModelProperty(" 身份识别标记")
    private String identificationFlag;

    @ApiModelProperty("英文姓名")
    private String nameEn;

    @ApiModelProperty("呼名")
    private String nickname;

    @ApiModelProperty("犬种")
    private String dogBreed;

    @ApiModelProperty("犬种中文名")
    private String dogBreedCn;

    @ApiModelProperty("毛色")
    private String colorFlag;

    @ApiModelProperty("性别")
    private String gender;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("出生日期")
    private Date birthdate;

    @ApiModelProperty("犬只DNA")
    private Integer dna;

    @ApiModelProperty("会员号")
    private String memberCode;

    @ApiModelProperty("犬主人")
    private String memberName;

    @ApiModelProperty("繁育人会员号")
    private String breederMemberCode;

    @ApiModelProperty("繁育人会员号")
    private String breederMemberName;

    @ApiModelProperty("新犬主")
    private String newMemberCode;

    @ApiModelProperty(value = "电子证书标记位：0否；1是")
    private Integer ecertFlag;

    @ApiModelProperty(value = "DNA办理方式：0机构办理；1自检")
    private Integer dnaApplyChannel;

    @ApiModelProperty(value = "医院编号")
    private String hospitalCode;

    @ApiModelProperty("公犬ID")
    private String maleDogId;

    @ApiModelProperty("公犬证书号")
    private String malePedigreeCertified;

	@ApiModelProperty("公犬出生纸编号")
	private String maleBirthCode;

	@ApiModelProperty("公犬国外证书号")
	private String maleOverseasPedigreeCertified;

    @ApiModelProperty("公犬DNA")
    private Integer maleDna;

    @ApiModelProperty("公犬会员号")
    private String maleMemberCode;

    @ApiModelProperty("公犬犬主人")
    private String maleMemberName;

    @ApiModelProperty("母犬ID")
    private String femaleDogId;

    @ApiModelProperty("母犬证书号")
    private String femalePedigreeCertified;

	@ApiModelProperty("母犬出生纸编号")
	private String femaleBirthCode;

	@ApiModelProperty("母犬国外证书号")
	private String femaleOverseasPedigreeCertified;

    @ApiModelProperty("母犬DNA")
    private Integer femaleDna;

    @ApiModelProperty("母犬会员号")
    private String femaleMemberCode;

    @ApiModelProperty("母犬犬主人")
    private String femaleMemberName;
}
