package com.cku.oa.dogsporting.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.show.entity.ShowApply;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.dogsporting.entity.DogSportingMembers;
import com.cku.oa.dogsporting.service.DogSportingMembersService;

import java.util.List;

/**
 * 犬运动会员Controller
 *
 * @author yuanshuai
 * @version 2021-06-15
 */
@Controller
@RequestMapping(value = "${adminPath}/dogsporting/member")
public class DogSportingMembersController extends BaseController {

	@Autowired
	private DogSportingMembersService dogSportingMembersService;


	@ModelAttribute
	public DogSportingMembers get(@RequestParam(required = false) String id) {
		DogSportingMembers entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogSportingMembersService.get(id);
		}
		if (entity == null) {
			entity = new DogSportingMembers();
		}
		return entity;
	}

	@RequiresPermissions("dogsporting:member:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogSportingMembers dogSportingMembers, HttpServletRequest request, HttpServletResponse response, Model model,@ModelAttribute("errorMsg") String errorMsg) {
		Page<DogSportingMembers> page = dogSportingMembersService.findPage(new Page<>(request, response), dogSportingMembers);
		model.addAttribute("page", page);
		model.addAttribute("errorMsg", errorMsg);
		return "oa/dogsporting/dogSportingMembersList";
	}

	@RequiresPermissions("dogsporting:member:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(DogSportingMembers dogSportingMembers, Model model) {
		model.addAttribute("dogSportingMembers", dogSportingMembers);
		model.addAttribute("isView", 1);
		return "oa/dogsporting/dogSportingMembersForm";
	}
	@RequiresPermissions("dogsporting:member:edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogSportingMembers dogSportingMembers, Model model) {
		model.addAttribute("dogSportingMembers", dogSportingMembers);
		model.addAttribute("isView", 0);
		return "oa/dogsporting/dogSportingMembersForm";
	}

	@RequiresPermissions("dogsporting:member:edit")
	@PostMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(DogSportingMembers dogSportingMembers) {
		try {
			restBeanValidator(dogSportingMembers);
			dogSportingMembersService.save(dogSportingMembers);
		} catch (Exception ex) {
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return ResultDto.success(dogSportingMembers.getId());
	}

	@RequiresPermissions("dogsporting:member:del")
	@RequestMapping(value = "delete")
	public String delete(DogSportingMembers dogSportingMembers, RedirectAttributes redirectAttributes) {
		if (StringUtils.isBlank(dogSportingMembers.getId())) {
			dogSportingMembersService.delete(dogSportingMembers);
			addMessage(redirectAttributes, "删除犬运动会员成功");
		} else {
			addMessage(redirectAttributes, "无法删除有效犬运动会员");
		}
		return "redirect:" + Global.getAdminPath() + "/dogsporting/member/?repage";
	}

	/**
	 * 导入模板
	 *
	 * @author yuanshuai
	 * @date 2021/6/22 17:15
	 */
	@RequiresPermissions("dogsporting:member:import")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			return dogSportingMembersService.importFileTemplate(response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dogsporting/member/?repage";
	}

	/**
	 * 导入
	 *
	 * @author yuanshuai
	 * @date 2021/6/22 17:15
	 */
	@RequiresPermissions("dogsporting:member:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			// 会员信息导入
			dogSportingMembersService.importMember(file);
			addMessage(redirectAttributes, "导入会员信息成功！");
		} catch (Exception e) {
			redirectAttributes.addFlashAttribute("errorMsg", "导入会员信息失败！失败信息：##" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dogsporting/member/?repage";
	}

	@GetMapping(value = "getByMemberCode")
	@ResponseBody
	public ResultDto<DogSportingMembers> getByMemberCode(HttpServletRequest request) {
		try {
			String memberCode = request.getParameter("memberCode");
			DogSportingMembers members = dogSportingMembersService.getByMemberCode(memberCode);
			if (members == null || StringUtils.isBlank(members.getId())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "没有会员号为" + memberCode + "的会员信息，请重新输入");
			}
			return ResultDto.success(members);
		} catch (Exception ex) {
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
	}

	/**
	 * 导出会员信息
	 * @author yuanshuai
	 * @date 2021/7/8 11:47
	 */
	@RequiresPermissions("dogsporting:member:export")
	@RequestMapping(value = "export", method = RequestMethod.POST)
	public String export(DogSportingMembers dogSportingMembers, HttpServletRequest request, HttpServletResponse response,
					   RedirectAttributes redirectAttributes) throws Exception {
		List<DogSportingMembers> list;
		try {
			list = dogSportingMembersService.export(dogSportingMembers);
			// 导出
			new ExportExcel("犬运动会员信息", DogSportingMembers.class, 2).setDataList(list).write(response, "犬运动会员信息.xlsx").dispose();
		} catch (Exception e) {
			e.printStackTrace();
			redirectAttributes.addFlashAttribute("errorMsg", "导出会员信息失败！失败信息：" + e.getMessage());
			return "redirect:" + Global.getAdminPath() + "/dogsporting/member/?repage";
		}
		return null;
	}

}