/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.annotation.MultiSubmit;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogDna;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.service.DogDnaArchiveReissueSamplingService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.vo.DogDnaArchiveVO;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.enums.SamplingDistributionChannelEnum;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.service.AreaService;

/**
 * 犬只DNA存档Controller
 *
 * @author lgl
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/dnaarchive/dogDnaArchive")
public class DogDnaArchiveController extends BaseController {

	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private DogDnaArchiveReissueSamplingService dogDnaArchiveReissueSamplingService;
	@Autowired
	private SamplingService samplingService;
	@Autowired
	private MemberService memberService;

	private final static String REPAGE = "redirect:" + Global.getAdminPath() + "/dnaarchive/dogDnaArchive/?repage";

	private final static String AUTHORITY_PRDFIX = "dnaarchive:dogDnaArchive:";

	@Autowired
	private AreaService areaService;

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogDnaArchive", new DogDnaArchive(runningNumber, chargingItemId, memberCode));
		return "oa/dog/dnaarchive/dogDnaArchiveOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getDogByPedigreeCertified")
	@ResponseBody
	public Object getDogByPedigreeCertified(@RequestParam(required = true) String pedigreeCertified) {
		HashMap<String, String> map = dogDnaArchiveService.getDogByPedigreeCertified(pedigreeCertified);
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getDogByBirthCode")
	@ResponseBody
	public Object getDogByBirthCode(@RequestParam(required = true) String birthCode) {
		HashMap<String, String> map = dogDnaArchiveService.getDogByBirthCode(birthCode);
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getDogByOverseasPedigreeCertified")
	@ResponseBody
	public Object getDogByOverseasPedigreeCertified(@RequestParam(required = true) String overseasPedigreeCertified) {
		HashMap<String, String> map = dogDnaArchiveService.getDogByOverseasPedigreeCertified(overseasPedigreeCertified);
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	@MultiSubmit
	public Object add(DogDnaArchive dogDnaArchive) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogDnaArchiveService.add(dogDnaArchive);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogDnaArchive dogDnaArchive, Model model) {
		List<DogDnaArchive> list = dogDnaArchiveService.findList(dogDnaArchive);

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogDnaArchiveVO> list2 = list.stream().map(a -> {
			DogDnaArchiveVO b = new DogDnaArchiveVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);

		return "oa/dog/dnaarchive/dogDnaArchiveOrderList";
	}

	@ModelAttribute
	public DogDnaArchive get(@RequestParam(required = false) String id) {
		DogDnaArchive entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogDnaArchiveService.get(id);
		}
		if (entity == null) {
			entity = new DogDnaArchive();
		}
		return entity;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogDnaArchive dogDnaArchive, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<DogDnaArchive> page = dogDnaArchiveService.findPage(new Page<DogDnaArchive>(request, response),
				dogDnaArchive);

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		// 查询采样包信息
		List<String> samplingCodeList = page.getList().stream().map(DogDnaArchive::getSamplingCode).distinct()
				.filter(StringUtils::isNotBlank).collect(Collectors.toList());
		List<Sampling> samplingList = Lists.newArrayList();
		if (!CollectionUtils.isEmpty(samplingCodeList)) {
			samplingList.addAll(samplingService.findListBySamplingCodeList(samplingCodeList));
		}
		List<DogDnaArchive> list = page.getList().stream()
				.map(da -> {
					DogDnaArchiveVO vo = new DogDnaArchiveVO();
					BeanUtils.copyProperties(da, vo);
					vo.setBusinessRefundState(map.keySet().contains(da.getId()));
					if (!CollectionUtils.isEmpty(samplingList)) {
						Sampling sampling = samplingList.stream()
								.filter(s -> s.getSamplingCode().equals(da.getSamplingCode()))
								.findFirst().orElse(null);
						if (Objects.nonNull(sampling) && StringUtils.isNotBlank(sampling.getId())) {
							vo.setSamplingFlowState(sampling.getFlowState());
						}
					}
					return vo;
				})
				.collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		if ("230".equals(dogDnaArchive.getDogBreed())) {
			return "oa/dog/dnaarchive/dogDnaArchiveListZangao";
		}
		return "oa/dog/dnaarchive/dogDnaArchiveList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogDnaArchive dogDnaArchive, Model model) {
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		return "oa/dog/dnaarchive/dogDnaArchiveForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogDnaArchive dogDnaArchive, Model model) {
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		return "oa/dog/dnaarchive/dogDnaArchiveEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "edit")
	public String edit(DogDnaArchive dogDnaArchive, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogDnaArchive)) {
			return editForm(dogDnaArchive, model);
		}
		dogDnaArchiveService.save(dogDnaArchive);
		addMessage(redirectAttributes, "编辑DNA存档成功");
		return repage(dogDnaArchive);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogDnaArchive dogDnaArchive, RedirectAttributes redirectAttributes) {
		try {
			dogDnaArchiveService.delete(dogDnaArchive);
			addMessage(redirectAttributes, "删除犬只DNA存档成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除犬只DNA存档失败:" + e.getMessage());
		}
		return repage(dogDnaArchive);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resolve")
	@RequestMapping(value = "resolveForm")
	public String resolveForm(DogDnaArchive dogDnaArchive, Model model) {
		model.addAttribute("dogDna", dogDnaArchiveService.resolveForm(dogDnaArchive));
		return "oa/dog/dnaarchive/dogDnaArchiveResolveForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resolve")
	@RequestMapping(value = "resolve")
	@ResponseBody
	public Object resolve(DogDna dogDna, HttpServletRequest request, Model model) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogDnaArchiveService.resolve(dogDna);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "audit")
	@ResponseBody
	public Object audit(DogDnaArchive dogDnaArchive) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogDnaArchiveService.audit(dogDnaArchive);
		} catch (Exception e) {
			logger.warn("审核失败", e);
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(String id, Model model) {
		return dogDnaArchiveService.auditForm(id, model);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "print")
	@RequestMapping(value = "print")
	public String print(DogDnaArchive dogDnaArchive, Model model) {
		DogDnaArchive print = dogDnaArchiveService.print(dogDnaArchive.getId());
		model.addAttribute("dogDnaArchive", print);
		if ("230".equals(print.getDogBreed())) {
			return "oa/dog/dnaarchive/dogDnaArchiveZangAoPrint";
		} else {
			return "oa/dog/dnaarchive/dogDnaArchivePrint";
		}
	}

	/**
	 * 重置打印
	 *
	 * @Author chaixueteng
	 * @2016年9月9日上午10:55:44
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(DogDnaArchive dogDnaArchive, Model model) {
		dogDnaArchiveService.resetPrintprint(dogDnaArchive.getId());
		return repage(dogDnaArchive);
	}

	/**
	 *
	 * @description: 根据犬种判断是否跳藏獒的列表页
	 * @author: laiguanglong
	 * @date: 2016年9月3日 下午3:48:33
	 */
	private String repage(DogDnaArchive dogDnaArchive) {
		if ("230".equals(dogDnaArchive.getDogBreed())) {
			return REPAGE + "&dogBreed=230";
		}
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "bind")
	@RequestMapping(value = "bindForm")
	public String bindForm(DogDnaArchive dogDnaArchive, Model model) {
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		return "oa/dog/dnaarchive/dogDnaArchiveBindForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "bind")
	@RequestMapping(value = "bind")
	@ResponseBody
	public ResultDto<String> bindSampling(DogDnaArchive dogDnaArchive) {
		try {
			dogDnaArchiveService.bindSampling(dogDnaArchive, Boolean.FALSE);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "绑定采样包失败：" + e.getMessage());
		}
		return ResultDto.success("绑定采样包成功");
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "editApplyChannel")
	@ResponseBody
	public ResultDto<String> editApplyChannel(DogDnaArchive dogDnaArchive) {
		try {
			dogDnaArchiveService.editApplyChannel(dogDnaArchive);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "修改办理方式失败：" + e.getMessage());
		}
		return ResultDto.success("修改办理方式成功");
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "rebind")
	@RequestMapping(value = "rebindForm")
	public String rebindForm(DogDnaArchive dogDnaArchive, Model model, RedirectAttributes redirectAttributes) {
		Sampling sampling = samplingService.findBySamplingCode(dogDnaArchive.getSamplingCode());
		if (Objects.nonNull(sampling)
				&& Objects.equals(SamplingDistributionChannelEnum.MEMBER.code(), sampling.getDistributionChannel())) {
			addMessage(redirectAttributes, "只有机构办理可以进行换绑操作");
			return REPAGE;
		}
		model.addAttribute("originSamplingCode", dogDnaArchive.getSamplingCode());
		dogDnaArchive.setSamplingCode(null);
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		return "oa/dog/dnaarchive/dogDnaArchiveRebindForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "rebind")
	@RequestMapping(value = "rebind")
	@ResponseBody
	public ResultDto<String> rebindSampling(DogDnaArchive dogDnaArchive) {
		try {
			dogDnaArchiveService.bindSampling(dogDnaArchive, Boolean.TRUE);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "换绑采样包失败：" + e.getMessage());
		}
		return ResultDto.success("换绑采样包成功");
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "unbind")
	@RequestMapping(value = "unbind")
	public String unbindSampling(DogDnaArchive dogDnaArchive, RedirectAttributes redirectAttributes) {
		try {
			dogDnaArchiveService.unbindSampling(dogDnaArchive);
			addMessage(redirectAttributes, "解绑采样包成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "解绑采样包失败:" + e.getMessage());
		}
		return repage(dogDnaArchive);
	}

	/**
	 * 补寄跳转
	 * 
	 * @param dogDnaArchive
	 * @param model
	 * @param redirectAttributes
	 * @return
	 */
	private static final String REISSUE_PAGE = "oa/dog/dnaarchive/dogDnaArchiveReissueForm";
	private static final String REISSUE_ERROR_KEY = "errorMsg";

	@RequiresPermissions(AUTHORITY_PRDFIX + "reissue")
	@RequestMapping(value = "reissueForm")
	public String reissueForm(DogDnaArchive dogDnaArchive, Model model, RedirectAttributes redirectAttributes) {

		if (StringUtils.isBlank(dogDnaArchive.getSamplingCode())) {
			model.addAttribute(REISSUE_ERROR_KEY, "该存档未绑定采样包，不允许补寄");
			return REISSUE_PAGE;
		}
		if (StringUtils.isNotBlank(dogDnaArchive.getDnaCode())) {
			model.addAttribute(REISSUE_ERROR_KEY, "该存档已存在DNA信息，不允许补寄");
			return REISSUE_PAGE;
		}
		Sampling sampling = samplingService.findBySamplingCode(dogDnaArchive.getSamplingCode());
		if (Objects.isNull(sampling)) {
			model.addAttribute(REISSUE_ERROR_KEY, "已绑定的采样包记录有误");
			return REISSUE_PAGE;
		}
		Member member = memberService.getByMemberCode(dogDnaArchive.getPaymentMemberCode());
		// 查询采样包绑定记录
		List<Sampling> bindSamplingRecord = dogDnaArchiveReissueSamplingService.findBindSamplingList(dogDnaArchive);
		if (!CollectionUtils.isEmpty(bindSamplingRecord) && bindSamplingRecord.size() >= 3) {
			model.addAttribute(REISSUE_ERROR_KEY, "该犬只已有三次补寄记录，无法办理该业务");
			return REISSUE_PAGE;
		}
		List<PaymentChargingItem> paymentChargingItemList = dogDnaArchiveReissueSamplingService
				.getReissueSamplingItem(dogDnaArchive, bindSamplingRecord);
		if (CollectionUtils.isEmpty(paymentChargingItemList)) {
			model.addAttribute(REISSUE_ERROR_KEY, "采样包补寄收费项配置错误，请联系管理员处理！");
			return REISSUE_PAGE;
		}
		// 计算订单总额
		BigDecimal orderTotal = paymentChargingItemList.stream().map(od -> {
			return new BigDecimal(od.getPrice());
		}).reduce(BigDecimal.ZERO, BigDecimal::add);
		model.addAttribute("bindSamplingRecord", bindSamplingRecord);
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		model.addAttribute("paymentChargingItemList", paymentChargingItemList);
		model.addAttribute("orderTotal", orderTotal);
		model.addAttribute("member", member);
		return REISSUE_PAGE;
	}

	/**
	 * 补寄下单
	 * 
	 * @param dogDnaArchive
	 * @return
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "reissue")
	@RequestMapping(value = "reissue")
	@ResponseBody
	public ResultDto<String> reissueSampling(DogDnaArchive dogDnaArchive) {
		try {
			dogDnaArchiveReissueSamplingService.reissueSampling(dogDnaArchive);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "补寄采样包失败：" + e.getMessage());
		}
		return ResultDto.success("补寄采样包成功");
	}

	/**
	 * 位点分析（口腔上皮细胞）
	 * 
	 * @param runningNumber
	 * @param chargingItemId
	 * @param memberCode
	 * @param model
	 * @return
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAddForOEC")
	public String orderAddForOEC(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogDnaArchive", new DogDnaArchive(runningNumber, chargingItemId, memberCode));
		model.addAttribute("provinceList", areaService.getProvince());
		return "oa/dog/dnaarchive/dogDnaArchiveOrderAddOEC";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "cancel")
	public String cancel(DogDnaArchive dogDnaArchive, RedirectAttributes redirectAttributes) {
		try {
			dogDnaArchiveService.cancel(dogDnaArchive);
			addMessage(redirectAttributes, "撤销犬只DNA存档成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "撤销犬只DNA存档失败:" + e.getMessage());
		}
		return repage(dogDnaArchive);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "blood2OEC")
	@RequestMapping(value = "blood2OEC")
	public String updateBlood2OEC(DogDnaArchive dogDnaArchive, RedirectAttributes redirectAttributes) {
		try {
			dogDnaArchiveService.updateBlood2OEC(dogDnaArchive);
			addMessage(redirectAttributes, "采集方式变更成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "采集方式变更失败:" + e.getMessage());
		}
		return repage(dogDnaArchive);
	}

}