package com.cku.oa.dog.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogAppraisalDao;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 芯片变更管理Service
 * @author zhuoHeng
 * @version 2016-10-14
 */
@Service
@Transactional(readOnly = true)
public class DogChipChangeService extends CrudService<DogChipChangeDao, DogChipChange> {
	
	@Autowired
	public DogService dogService;
	@Autowired
	public DogBirthCertificateDao birthCertificateDao;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private DogAppraisalDao dogAppraisalDao;
	@Autowired
	private DogPedigreeCertifiedChangeDao dogPedigreeCertifiedChangeDao;


	public DogChipChange get(String id) {
		return super.get(id);
	}
	
	public List<DogChipChange> findList(DogChipChange dogChipChange) {
		return super.findList(dogChipChange);
	}
	
	public Page<DogChipChange> findPage(Page<DogChipChange> page, DogChipChange dogChipChange) {
		return super.findPage(page, dogChipChange);
	}
	
	@Transactional(readOnly = false)
	public void save(DogChipChange dogChipChange) {
		super.save(dogChipChange);
	}
	
	@Transactional(readOnly = false)
	public void delete(DogChipChange dogChipChange) {
		super.delete(dogChipChange);
	}

	/**
	 * 
	 * @Description：芯片变更业务信息保存
	 * @author: zhuoHeng
	 * @version: 2016年10月14日 下午2:19:03
	 */
	@Transactional(readOnly = false)
	public String orderSave(DogChipChange dogChipChange,String check,String dogCode) {
		if(StringUtils.isBlank(dogChipChange.getChipCodeNew())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"新芯片号不能为空");
		}
		String returnFlag = "ok";
		if ("1".equals(check)) {
			//通过血统证书号登记
			if (dogChipChange.getDogId() != null && !"".equals(dogChipChange.getDogId())) {
				Dog dog = dogService.get(dogChipChange.getDogId());
				//变更犬只信息表中的芯片号
				Dog update = new Dog();
				update.setId(dogChipChange.getDogId());
				update.setIdentificationFlag(dogChipChange.getChipCodeNew());
				dogService.updateDogChip(update);
				//变更出生纸表中的芯片号
				if (StringUtils.isNotBlank(dog.getBirthCertificateLevelCode())) {
					dogChipChange.setBirthCode(dog.getBirthCertificateLevelCode());
					DogBirthCertificate dogBirthCertificate = new DogBirthCertificate();
					dogBirthCertificate.setPedigreeCertified(dog.getPedigreeCertifiedCode());
					dogBirthCertificate.setIdentificationFlag(dogChipChange.getChipCodeNew());
					birthCertificateDao.updateDogChipByPed(dogBirthCertificate);
				}
			}
		} else if ("2".equals(check)) {
			dogChipChange.setBirthCode(dogCode);
			//通过出生纸编号登记
			DogBirthCertificate dogBirthCertificate = new DogBirthCertificate();
			dogBirthCertificate.setBirthCerRegCode(dogCode);
			dogBirthCertificate.setIdentificationFlag(dogChipChange.getChipCodeNew());
			//变更出生纸表中的芯片号
			birthCertificateDao.updateDogChip(dogBirthCertificate);
			//更新犬只信息中芯片号
			Dog dog = dogService.getByBirthCertificateLevelCode(dogCode);
			if (Objects.nonNull(dog) && StringUtils.isNotBlank(dog.getId())) {
				dogChipChange.setDogId(dog.getId());
				Dog update = new Dog();
				update.setId(dog.getId());
				update.setIdentificationFlag(dogChipChange.getChipCodeNew());
				dogService.updateDogChip(update);
			}
		} else if ("3".equals(check)) {
			dogChipChange.setShowAppraisalCode(dogCode);
			//通过赛场犬只鉴定编号登记
			DogAppraisal dogAppraisal = dogAppraisalDao.getByShowAppraisalCode(dogCode);
			//1赛场鉴定记录未关联订单
			if (StringUtils.isNotBlank(dogAppraisal.getShowAppraisalOrderRunningNumber())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该赛场鉴定记录已经录入订单，请检查");
			}
			//2赛场鉴定记录付款会员号与订单会员号一致
			if (!dogAppraisal.getPaymentMemberCode().equals(dogChipChange.getPaymentMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该赛场鉴定记录的付款人会员号与订单会员号不一致，请检查");
			}
			dogAppraisal.setDogChip(dogChipChange.getChipCodeNew());
			dogAppraisalDao.update(dogAppraisal);
			//更新犬只信息中芯片号
			if(StringUtils.isNotBlank(dogAppraisal.getDogId())){
				dogChipChange.setDogId(dogAppraisal.getDogId());
				Dog update = new Dog();
				update.setId(dogAppraisal.getDogId());
				update.setIdentificationFlag(dogChipChange.getChipCodeNew());
				dogService.updateDogChip(update);
			}
		} else if ("4".equals(check)) {
			dogChipChange.setOverseasPedigreeCertified(dogCode);
			//通过外国血统证书号登记
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeDao.getByOverseasPedigreeCertified(dogCode);
			//更新证书换发的芯片号
			dogPedigreeCertifiedChange.setDogChip(dogChipChange.getChipCodeNew());
			dogPedigreeCertifiedChangeDao.update(dogPedigreeCertifiedChange);
			//更新犬只信息中芯片号
			if(StringUtils.isNotBlank(dogPedigreeCertifiedChange.getDogId())){
				dogChipChange.setDogId(dogPedigreeCertifiedChange.getDogId());
				Dog update = new Dog();
				update.setId(dogPedigreeCertifiedChange.getDogId());
				update.setIdentificationFlag(dogChipChange.getChipCodeNew());
				dogService.updateDogChip(update);
			}
		}
		
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setPaymentState("2");
		PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(dogChipChange.getRunningNumber());
		dogChipChange.setPaymentTime(paymentOrder.getCreateDate());
		dogChipChange.setProcessState("1");
		dogChipChange.setProcessTime(new Date());
		dogChipChange.setIsNewRecord(true);
		//芯片变更记录表中增加一条变更记录
		super.save(dogChipChange);
		return returnFlag;
	}

	/**
	 * 根据芯片号查询
	 * @Author chaixueteng
	 * @2016年10月12日下午4:04:33
	 */
	public DogChipChange getByIdentificationFlag(String identificationFlag) {
		return dao.getByIdentificationFlag(identificationFlag);
	}
	public DogChipChange getByOverseasPedigreeCertified(String overseasPedigreeCertified) {
		return dao.getByOverseasPedigreeCertified(overseasPedigreeCertified);
	}
	
	
	
}