/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 犬只精子变更Entity
 *
 * @author lgl
 * @version 2017-08-29
 */
public class DogSemenChange extends DataEntity<DogSemenChange> {

    private static final long serialVersionUID = 1L;
    private String dogId;        // 犬只表主键
    private String pedigreeCertified;        // 犬只血统证书号
    private String dogChip;        // 犬只芯片
    private String dogBreed;        // 犬种号
    private String dogName;        // 犬名
    private String originMemberCode;        // 原犬只精子会员号
    private String originMemberName;        // 原犬只精子会员姓名
    private String newMemberCode;        // 新犬只精子会员号
    private String newMemberName;        // 新原犬只精子会员姓名
    private String semenCode;        // CKU精子编号
    private String runningNumber;        // 流水号
    private String paymentState;        // 付款的状态
    private Date paymentTime;        // 付款时间
    private String reviewState;        // 审核状态
    private Date reviewTime;        // 审核时间
    private String reviewRemarks;        // 审核的意见
    private String ckuReviewState;        // 协会审核状态
    private Date ckuReviewTime;        // 协会审核时间
    private String ckuReviewRemarks;        // 协会审核的意见
    private String processState;        // 流程状态
    private Date processTime;        // 流程变更的时间

    public DogSemenChange() {
        super();
    }

    public DogSemenChange(String id) {
        super(id);
    }

    @Length(min = 1, max = 64, message = "犬只表主键长度必须介于 1 和 64 之间")
    public String getDogId() {
        return dogId;
    }

    public void setDogId(String dogId) {
        this.dogId = dogId;
    }

    @Length(min = 1, max = 64, message = "犬只血统证书号长度必须介于 1 和 64 之间")
    public String getPedigreeCertified() {
        return pedigreeCertified;
    }

    public void setPedigreeCertified(String pedigreeCertified) {
        this.pedigreeCertified = pedigreeCertified;
    }

    @Length(min = 1, max = 64, message = "犬只芯片长度必须介于 1 和 64 之间")
    public String getDogChip() {
        return dogChip;
    }

    public void setDogChip(String dogChip) {
        this.dogChip = dogChip;
    }

    @Length(min = 1, max = 64, message = "犬种号长度必须介于 1 和 64 之间")
    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

    @Length(min = 1, max = 64, message = "犬名长度必须介于 1 和 64 之间")
    public String getDogName() {
        return dogName;
    }

    public void setDogName(String dogName) {
        this.dogName = dogName;
    }

    @Length(min = 1, max = 64, message = "原犬只精子会员号长度必须介于 1 和 64 之间")
    public String getOriginMemberCode() {
        return originMemberCode;
    }

    public void setOriginMemberCode(String originMemberCode) {
        this.originMemberCode = originMemberCode;
    }

    @Length(min = 1, max = 64, message = "原犬只精子会员姓名长度必须介于 1 和 64 之间")
    public String getOriginMemberName() {
        return originMemberName;
    }

    public void setOriginMemberName(String originMemberName) {
        this.originMemberName = originMemberName;
    }

    @Length(min = 1, max = 64, message = "新犬只精子会员号长度必须介于 1 和 64 之间")
    public String getNewMemberCode() {
        return newMemberCode;
    }

    public void setNewMemberCode(String newMemberCode) {
        this.newMemberCode = newMemberCode;
    }

    @Length(min = 1, max = 64, message = "新原犬只精子会员姓名长度必须介于 1 和 64 之间")
    public String getNewMemberName() {
        return newMemberName;
    }

    public void setNewMemberName(String newMemberName) {
        this.newMemberName = newMemberName;
    }

    @Length(min = 1, max = 200, message = "CKU精子编号长度必须介于 1 和 200 之间")
    public String getSemenCode() {
        return semenCode;
    }

    public void setSemenCode(String semenCode) {
        this.semenCode = semenCode;
    }

    @Length(min = 1, max = 100, message = "流水号长度必须介于 1 和 100 之间")
    public String getRunningNumber() {
        return runningNumber;
    }

    public void setRunningNumber(String runningNumber) {
        this.runningNumber = runningNumber;
    }

    @Length(min = 1, max = 20, message = "付款的状态长度必须介于 1 和 20 之间")
    public String getPaymentState() {
        return paymentState;
    }

    public void setPaymentState(String paymentState) {
        this.paymentState = paymentState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    @Length(min = 1, max = 20, message = "审核状态长度必须介于 1 和 20 之间")
    public String getReviewState() {
        return reviewState;
    }

    public void setReviewState(String reviewState) {
        this.reviewState = reviewState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    @Length(min = 1, max = 200, message = "审核的意见长度必须介于 1 和 200 之间")
    public String getReviewRemarks() {
        return reviewRemarks;
    }

    public void setReviewRemarks(String reviewRemarks) {
        this.reviewRemarks = reviewRemarks;
    }

    public String getCkuReviewState() {
        return ckuReviewState;
    }

    public void setCkuReviewState(String ckuReviewState) {
        this.ckuReviewState = ckuReviewState;
    }

    public Date getCkuReviewTime() {
        return ckuReviewTime;
    }

    public void setCkuReviewTime(Date ckuReviewTime) {
        this.ckuReviewTime = ckuReviewTime;
    }

    public String getCkuReviewRemarks() {
        return ckuReviewRemarks;
    }

    public void setCkuReviewRemarks(String ckuReviewRemarks) {
        this.ckuReviewRemarks = ckuReviewRemarks;
    }

    @Length(min = 1, max = 20, message = "流程状态长度必须介于 1 和 20 之间")
    public String getProcessState() {
        return processState;
    }

    public void setProcessState(String processState) {
        this.processState = processState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getProcessTime() {
        return processTime;
    }

    public void setProcessTime(Date processTime) {
        this.processTime = processTime;
    }

    private String pedigreeCertifiedLike;        // 犬只血统证书号模糊查询
    private String semenCodeLike;        // CKU精子编号模糊查询
    private String newMemberCodeAndNewMemberNameLike;        // 新精子主人和姓名模糊查询
    private String originMemberCodeAndOriginMemberNameLike;        // 原精子主人和姓名模糊查询
    private String pedigreeCertifiedAndDogChipLike;        // 血统证书号和芯片号模糊查询条件
    private Date createDateStart;// 申请时间开始
    private Date createDateEnd;// 申请时间结束

    public String getPedigreeCertifiedLike() {
        return pedigreeCertifiedLike;
    }

    public void setPedigreeCertifiedLike(String pedigreeCertifiedLike) {
        this.pedigreeCertifiedLike = pedigreeCertifiedLike;
    }

    public String getSemenCodeLike() {
        return semenCodeLike;
    }

    public void setSemenCodeLike(String semenCodeLike) {
        this.semenCodeLike = semenCodeLike;
    }

    public String getNewMemberCodeAndNewMemberNameLike() {
        return newMemberCodeAndNewMemberNameLike;
    }

    public void setNewMemberCodeAndNewMemberNameLike(String newMemberCodeAndNewMemberNameLike) {
        this.newMemberCodeAndNewMemberNameLike = newMemberCodeAndNewMemberNameLike;
    }

    public String getOriginMemberCodeAndOriginMemberNameLike() {
        return originMemberCodeAndOriginMemberNameLike;
    }

    public void setOriginMemberCodeAndOriginMemberNameLike(String originMemberCodeAndOriginMemberNameLike) {
        this.originMemberCodeAndOriginMemberNameLike = originMemberCodeAndOriginMemberNameLike;
    }

    public String getPedigreeCertifiedAndDogChipLike() {
        return pedigreeCertifiedAndDogChipLike;
    }

    public void setPedigreeCertifiedAndDogChipLike(String pedigreeCertifiedAndDogChipLike) {
        this.pedigreeCertifiedAndDogChipLike = pedigreeCertifiedAndDogChipLike;
    }

    public Date getCreateDateStart() {
        return createDateStart;
    }

    public void setCreateDateStart(Date createDateStart) {
        this.createDateStart = createDateStart;
    }

    public Date getCreateDateEnd() {
        return createDateEnd;
    }

    public void setCreateDateEnd(Date createDateEnd) {
        this.createDateEnd = createDateEnd;
    }

    public String getBusinessState() {
        if ("0".equals(reviewState)) {
            return "待审核";
        } else if ("1".equals(reviewState)) {
            if ("0".equals(ckuReviewState)) {
                return "原主人通过";
            } else if ("1".equals(ckuReviewState)) {
                return "协会通过";
            } else if ("2".equals(ckuReviewState)) {
                return "协会未通过";
            }
        } else if ("2".equals(reviewState)) {
            return "原主人未通过";
        }
        return "";
    }
}