/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import com.cku.oa.finance.entity.PaymentChargingItem;
import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 配种证明Entity
 * @author zhuoHeng
 * @version 2016-08-02
 */
public class DogNewborn extends DataEntity<DogNewborn> {

	private static final long serialVersionUID = 1L;
	private String breedCertifiedCode;		// 配种证明编号
	private String area;		// 所属地区
	private String maleDogOwner;		// 公犬主人姓名
	private String mdogOwnerCode;		// 公犬主人会员号
	private String femaleDogOwner;		// 母犬主人姓名
	private String fdogOwnerCode;		// 母犬主人会员号
	private String maleDogName;		// 公犬姓名
	private String malePedigreeCertified;		// 公犬证书号
	private String femaleDogName;		// 母犬姓名
	private String femalePedigreeCertified;		// 母犬证书号
	private Date breedDate;		// 配种日期
	private Date birthday;		// 出生日期
	private String puppyBirthNum;		// 出生数（几公几母）
	private String puppyRegisterNum;		// 登记数（几公几母）
	private String maleDogOwnerTopup;		// 公犬主续费（是否）
	private String femaleDogOwnerTopup;		// 母犬主续费（是否）
	private String batchFee;		// 窝费（已缴 未缴费）
	private String implantedNum;		// 已植数量
	private String register;		// 登记人
	private String remark;		// 备注
	private String dogRegisterNum;		// CKU登记数
	private String dogBreed;		// 犬种类
	private String operator;		// 操作人
	private String kinBreed;		// 近亲繁殖
	private String price;		// 价格
	private String birthCertificate;		// 出生证明
	private String printType;		// 打印类型
	private String kinGetDna;		// 近亲繁殖取DNA
	private String batchNum;		// 配种证明窝号
	private String urgent;		// 加急
	private String semenCode;		// 精子编号
	private String semenOwnerMemberCode;		// 精子所有者会员号
	private Date dogWoTime;		// 窝
	private String reviewState;		// 审核状态 0:待审核 1:已通过 2:未通过 3:已注销
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private Date processTime;		// 流程变更的时间
	private String processState;		// 流程状态
	private String token;	//宠爱王国访问令牌

	private String paymentChargingItemId;		// 收费项id

	private DogType dogType;   //犬种类信息表

	PaymentChargingItem paymentChargingItem;	//配种证明收费项

	private String canApplyDogBirthCertificateFlag;

	public DogNewborn() {
		super();
	}

	public DogNewborn(String id){
		super(id);
	}

	@Length(min=0, max=64, message="配种证明编号长度必须介于 0 和 64 之间")
	public String getBreedCertifiedCode() {
		return breedCertifiedCode;
	}

	public void setBreedCertifiedCode(String breedCertifiedCode) {
		this.breedCertifiedCode = breedCertifiedCode;
	}

	@Length(min=0, max=64, message="所属地区长度必须介于 0 和 64 之间")
	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	@Length(min=0, max=64, message="公犬主人姓名长度必须介于 0 和 64 之间")
	public String getMaleDogOwner() {
		return maleDogOwner;
	}

	public void setMaleDogOwner(String maleDogOwner) {
		this.maleDogOwner = maleDogOwner;
	}

	@Length(min=0, max=64, message="公犬主人会员号长度必须介于 0 和 64 之间")
	public String getMdogOwnerCode() {
		return mdogOwnerCode;
	}

	public void setMdogOwnerCode(String mdogOwnerCode) {
		this.mdogOwnerCode = mdogOwnerCode;
	}

	@Length(min=0, max=64, message="母犬主人姓名长度必须介于 0 和 64 之间")
	public String getFemaleDogOwner() {
		return femaleDogOwner;
	}

	public void setFemaleDogOwner(String femaleDogOwner) {
		this.femaleDogOwner = femaleDogOwner;
	}

	@Length(min=0, max=64, message="母犬主人会员号长度必须介于 0 和 64 之间")
	public String getFdogOwnerCode() {
		return fdogOwnerCode;
	}

	public void setFdogOwnerCode(String fdogOwnerCode) {
		this.fdogOwnerCode = fdogOwnerCode;
	}

	@Length(min=0, max=255, message="公犬姓名长度必须介于 0 和 255 之间")
	public String getMaleDogName() {
		return maleDogName;
	}

	public void setMaleDogName(String maleDogName) {
		this.maleDogName = maleDogName;
	}

	@Length(min=0, max=64, message="公犬证书号长度必须介于 0 和 64 之间")
	public String getMalePedigreeCertified() {
		return malePedigreeCertified;
	}

	public void setMalePedigreeCertified(String malePedigreeCertified) {
		this.malePedigreeCertified = malePedigreeCertified;
	}

	@Length(min=0, max=255, message="母犬姓名长度必须介于 0 和 255 之间")
	public String getFemaleDogName() {
		return femaleDogName;
	}

	public void setFemaleDogName(String femaleDogName) {
		this.femaleDogName = femaleDogName;
	}

	@Length(min=0, max=64, message="母犬证书号长度必须介于 0 和 64 之间")
	public String getFemalePedigreeCertified() {
		return femalePedigreeCertified;
	}

	public void setFemalePedigreeCertified(String femalePedigreeCertified) {
		this.femalePedigreeCertified = femalePedigreeCertified;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBreedDate() {
		return breedDate;
	}

	public void setBreedDate(Date breedDate) {
		this.breedDate = breedDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	@Length(min=0, max=10, message="出生数（几公几母）长度必须介于 0 和 10 之间")
	public String getPuppyBirthNum() {
		return puppyBirthNum;
	}

	public void setPuppyBirthNum(String puppyBirthNum) {
		this.puppyBirthNum = puppyBirthNum;
	}

	@Length(min=0, max=10, message="登记数（几公几母）长度必须介于 0 和 10 之间")
	public String getPuppyRegisterNum() {
		return puppyRegisterNum;
	}

	public void setPuppyRegisterNum(String puppyRegisterNum) {
		this.puppyRegisterNum = puppyRegisterNum;
	}

	@Length(min=0, max=1, message="公犬主续费（是否）长度必须介于 0 和 1 之间")
	public String getMaleDogOwnerTopup() {
		return maleDogOwnerTopup;
	}

	public void setMaleDogOwnerTopup(String maleDogOwnerTopup) {
		this.maleDogOwnerTopup = maleDogOwnerTopup;
	}

	@Length(min=0, max=1, message="母犬主续费（是否）长度必须介于 0 和 1 之间")
	public String getFemaleDogOwnerTopup() {
		return femaleDogOwnerTopup;
	}

	public void setFemaleDogOwnerTopup(String femaleDogOwnerTopup) {
		this.femaleDogOwnerTopup = femaleDogOwnerTopup;
	}

	@Length(min=0, max=50, message="窝费（已缴 未缴费）长度必须介于 0 和 50 之间")
	public String getBatchFee() {
		return batchFee;
	}

	public void setBatchFee(String batchFee) {
		this.batchFee = batchFee;
	}

	@Length(min=0, max=11, message="已植数量长度必须介于 0 和 11 之间")
	public String getImplantedNum() {
		return implantedNum;
	}

	public void setImplantedNum(String implantedNum) {
		this.implantedNum = implantedNum;
	}

	@Length(min=0, max=64, message="登记人长度必须介于 0 和 64 之间")
	public String getRegister() {
		return register;
	}

	public void setRegister(String register) {
		this.register = register;
	}

	@Length(min=0, max=256, message="备注长度必须介于 0 和 256 之间")
	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	@Length(min=0, max=64, message="CKU登记数长度必须介于 0 和 64 之间")
	public String getDogRegisterNum() {
		return dogRegisterNum;
	}

	public void setDogRegisterNum(String dogRegisterNum) {
		this.dogRegisterNum = dogRegisterNum;
	}

	@Length(min=0, max=10, message="犬种类长度必须介于 0 和 10 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min=0, max=1000, message="操作人长度必须介于 0 和 1000 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	@Length(min=0, max=64, message="近亲繁殖长度必须介于 0 和 64 之间")
	public String getKinBreed() {
		return kinBreed;
	}

	public void setKinBreed(String kinBreed) {
		this.kinBreed = kinBreed;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min=0, max=11, message="出生证明长度必须介于 0 和 11 之间")
	public String getBirthCertificate() {
		return birthCertificate;
	}

	public void setBirthCertificate(String birthCertificate) {
		this.birthCertificate = birthCertificate;
	}

	@Length(min=0, max=10, message="打印类型长度必须介于 0 和 10 之间")
	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	@Length(min=0, max=64, message="近亲繁殖取DNA长度必须介于 0 和 64 之间")
	public String getKinGetDna() {
		return kinGetDna;
	}

	public void setKinGetDna(String kinGetDna) {
		this.kinGetDna = kinGetDna;
	}

	@Length(min=0, max=64, message="配种证明窝号长度必须介于 0 和 64 之间")
	public String getBatchNum() {
		return batchNum;
	}

	public void setBatchNum(String batchNum) {
		this.batchNum = batchNum;
	}

	@Length(min=0, max=1, message="加急长度必须介于 0 和 1 之间")
	public String getUrgent() {
		return urgent;
	}

	public void setUrgent(String urgent) {
		this.urgent = urgent;
	}

	public String getSemenCode() {
		return semenCode;
	}

	public void setSemenCode(String semenCode) {
		this.semenCode = semenCode;
	}

	public String getSemenOwnerMemberCode() {
		return semenOwnerMemberCode;
	}

	public void setSemenOwnerMemberCode(String semenOwnerMemberCode) {
		this.semenOwnerMemberCode = semenOwnerMemberCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getDogWoTime() {
		return dogWoTime;
	}

	public void setDogWoTime(Date dogWoTime) {
		this.dogWoTime = dogWoTime;
	}

	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min=0, max=20, message="流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

    public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public DogType getDogType() {
        return dogType;
    }

    public void setDogType(DogType dogType) {
        this.dogType = dogType;
    }

	public PaymentChargingItem getPaymentChargingItem() {
		return paymentChargingItem;
	}

	public void setPaymentChargingItem(PaymentChargingItem paymentChargingItem) {
		this.paymentChargingItem = paymentChargingItem;
	}

	private String memberCode;//会员端查询所需字段

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getCanApplyDogBirthCertificateFlag() {
		return canApplyDogBirthCertificateFlag;
	}

	public void setCanApplyDogBirthCertificateFlag(String canApplyDogBirthCertificateFlag) {
		this.canApplyDogBirthCertificateFlag = canApplyDogBirthCertificateFlag;
	}
}