/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 芯片变更管理Entity
 * @author zhuoHeng
 * @version 2016-10-14
 */
public class DogChipChange extends DataEntity<DogChipChange> {
	
	private static final long serialVersionUID = 1L;
	private String dogId;		// 犬只id
	private String birthCode;		// 出生纸编号
	private String overseasPedigreeCertified;		// 国外血统证书号
	private String showAppraisalCode;		//赛场鉴定编号
	private String chipCodeOld;		// 旧芯片号
	private String chipCodeNew;		// 新芯片号
	private String paymentMemberCode;		// 缴费会员号
	private String operator;		// operator
	private String price;		// 价格
	private String organizationUsername;		// 机构用户名
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private Date processTime;		// 流程变更的时间
	private String processState;		// 流程状态
	
	public DogChipChange() {
		super();
	}

	public DogChipChange(String id){
		super(id);
	}

	@Length(min=0, max=64, message="犬只id长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	public String getBirthCode() {
		return birthCode;
	}

	public void setBirthCode(String birthCode) {
		this.birthCode = birthCode;
	}

	public String getOverseasPedigreeCertified() {
		return overseasPedigreeCertified;
	}

	public void setOverseasPedigreeCertified(String overseasPedigreeCertified) {
		this.overseasPedigreeCertified = overseasPedigreeCertified;
	}

	public String getShowAppraisalCode() {
		return showAppraisalCode;
	}

	public void setShowAppraisalCode(String showAppraisalCode) {
		this.showAppraisalCode = showAppraisalCode;
	}

	@Length(min=0, max=64, message="旧芯片号长度必须介于 0 和 64 之间")
	public String getChipCodeOld() {
		return chipCodeOld;
	}

	public void setChipCodeOld(String chipCodeOld) {
		this.chipCodeOld = chipCodeOld;
	}
	
	@Length(min=0, max=64, message="新芯片号长度必须介于 0 和 64 之间")
	public String getChipCodeNew() {
		return chipCodeNew;
	}

	public void setChipCodeNew(String chipCodeNew) {
		this.chipCodeNew = chipCodeNew;
	}
	
	@Length(min=0, max=64, message="缴费会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}
	
	@Length(min=0, max=64, message="operator长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
	
	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}
	
	@Length(min=0, max=64, message="机构用户名长度必须介于 0 和 64 之间")
	public String getOrganizationUsername() {
		return organizationUsername;
	}

	public void setOrganizationUsername(String organizationUsername) {
		this.organizationUsername = organizationUsername;
	}
	
	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=50, message="审核的意见长度必须介于 0 和 50 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}
	
	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}
	
	@Length(min=0, max=20, message="流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}
	
}