/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛制年龄组别对照Entity
 * @author yuanshuai
 * @version 2020-11-05
 */
public class ContestJudgeTypeClass extends DataEntity<ContestJudgeTypeClass> {
	
	private static final long serialVersionUID = 1L;
	private String judgeType;		// judge_type
	private String classNo;		// class_no
	private String code;		// code
	private String name;		// name
	private String sortNo;		// sort_no
	
	public ContestJudgeTypeClass() {
		super();
	}

	public ContestJudgeTypeClass(String id){
		super(id);
	}

	@Length(min=1, max=32, message="judge_type长度必须介于 1 和 32 之间")
	public String getJudgeType() {
		return judgeType;
	}

	public void setJudgeType(String judgeType) {
		this.judgeType = judgeType;
	}
	
	@Length(min=1, max=11, message="class_no长度必须介于 1 和 11 之间")
	public String getClassNo() {
		return classNo;
	}

	public void setClassNo(String classNo) {
		this.classNo = classNo;
	}
	
	@Length(min=1, max=32, message="code长度必须介于 1 和 32 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=1, max=255, message="name长度必须介于 1 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=1, max=11, message="sort_no长度必须介于 1 和 11 之间")
	public String getSortNo() {
		return sortNo;
	}

	public void setSortNo(String sortNo) {
		this.sortNo = sortNo;
	}
	
}