/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.clubdog.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 淘宠新生犬登记Entity
 * @author cxt
 * @version 2017-11-06
 */
public class TcbDogChip extends DataEntity<TcbDogChip> {
	
	private static final long serialVersionUID = 1L;
	private String birthCode;		// 出生纸编号（该字段有值表示从新生犬登记业务产生的）
	private String chipCode;		// 芯片号
	private String orgId;		// 俱乐部id
	private String orgCode;		// 俱乐部会员号
	private String operator;		// operator
	private String price;		// 价格
	
	public TcbDogChip() {
		super();
	}

	public TcbDogChip(String id){
		super(id);
	}

	@Length(min=1, max=64, message="出生纸编号（该字段有值表示从新生犬登记业务产生的）长度必须介于 1 和 64 之间")
	public String getBirthCode() {
		return birthCode;
	}

	public void setBirthCode(String birthCode) {
		this.birthCode = birthCode;
	}
	
	@Length(min=0, max=64, message="芯片号长度必须介于 0 和 64 之间")
	public String getChipCode() {
		return chipCode;
	}

	public void setChipCode(String chipCode) {
		this.chipCode = chipCode;
	}
	
	@Length(min=1, max=64, message="俱乐部id长度必须介于 1 和 64 之间")
	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}
	
	@Length(min=0, max=64, message="俱乐部会员号长度必须介于 0 和 64 之间")
	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	
	@Length(min=0, max=64, message="operator长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
	
	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}
	
}