package com.cku.oa.banner.service;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageResultDto;
import com.cku.oa.banner.dao.AppBannerDao;
import com.cku.oa.banner.entity.AppBanner;
import com.cku.restful.v1.banner.vo.RestBannerListRequest;
import com.cku.restful.v1.banner.vo.RestBannerListResponse;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 广告位管理Service
 * 
 * @author zhaoxy
 * @version 2021-01-13
 */
@Service
@Transactional(readOnly = true)
public class AppBannerService extends CrudService<AppBannerDao, AppBanner> {

	public AppBanner get(String id) {
		return super.get(id);
	}
	
	public AppBanner findByParam(AppBanner appBanner) {
		return dao.findByParam(appBanner);
	}
	
	public List<AppBanner> findList(AppBanner appBanner) {
		return super.findList(appBanner);
	}

	public Page<AppBanner> findPage(Page<AppBanner> page, AppBanner appBanner) {
		Page<AppBanner> resultPage = super.findPage(page, appBanner);
		List<AppBanner> bannerList = resultPage.getList();
		for (AppBanner banner : bannerList) {
			Date nowDate = new Date();
			if (nowDate.before(banner.getStartDate())) {
				banner.setBannerTimeStatusDesc("未开始");
			} else if (nowDate.after(banner.getStartDate()) && nowDate.before(banner.getEndDate())) {
				banner.setBannerTimeStatusDesc("进行中");
			} else if (nowDate.after(banner.getEndDate())) {
				banner.setBannerTimeStatusDesc("已结束");
			}
		}
		return resultPage;
	}

	@Transactional(readOnly = false)
	public void save(AppBanner appBanner) {
		appBanner.setBannerAction("1");
		appBanner.setCreateDate(new Date());
		super.save(appBanner);
	}

	@Transactional(readOnly = false)
	public void delete(AppBanner appBanner) {
		super.delete(appBanner);
	}

	@Transactional(readOnly = false)
	public void editStatus(AppBanner appBanner) {
		dao.editStatus(appBanner);
	}

	public PageResultDto<RestBannerListResponse> list(RestBannerListRequest vo, HttpServletRequest request,
			HttpServletResponse response) {
		vo.setPageNo(vo.getPageNo() < 1 ? 1 : vo.getPageNo());
		vo.setPageNo((vo.getPageNo() - 1) * vo.getPageSize());
		Integer count = dao.listCount(vo);
		List<RestBannerListResponse> resultList = dao.list(vo);
		for(RestBannerListResponse resp : resultList) {
			String path = request.getContextPath();
			String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+resp.getBannerImg();
			resp.setBannerImg(imgPath);
			resp.setKennelType(DictUtils.getDictLabel(resp.getKennelType(), "kennel_type", ""));
		}
		Integer totalPage = (count  +  vo.getPageSize()  - 1) / vo.getPageSize();
		// 热门犬舍/犬舍联盟展示顺序改为随机
		if (!"1".equals(vo.getBannerPlace())) {
			Collections.shuffle(resultList);
		}
		return PageResultDto.success(resultList, count.longValue(), totalPage.longValue());
	}

}