<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<%@page import="com.cku.oa.sys.entity.user.MemberCardTypeEnum"%>
<html>
<head>
	<title>合作机构会员管理</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {

			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2(); 
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var option = "";
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${member.province}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#province").append(html);
						if(option!=''){
							$("#province").val(option).select2().change();
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

	</script>
</head>
<body>
	<h2>合作机构会员管理</h2>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	<form:form id="searchForm" modelAttribute="member" action="${ctxPartner}/clubMember/singleClub/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		
		<ul class="ul-form">
			<li>
				<label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>电话：</label>
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>省：</label>
				<form:select id="province" path="province" class="input-small">
				</form:select>
			</li>
			<script>
				$("#province").change(function(){
					$("#city").empty().val("").select2();
					$("#area").empty().val("").select2();
					var code = $(this).find("option:selected").attr("code");
					$.ajax({
						url:'${ctxCity}',
						data: {province_code:code},
						async:true,
						loadFlag:true,
						type:'get',
						cache:false,
						success:function(json){
							if(json.rc==0){
								var option = "";
								var html = "<option value='' code=''>请选择城市</option>";
								var lists = json.items;
								for(var i = 0;i<lists.length;i++){
									html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
									if('${member.city}'==lists[i].city) {
										option = lists[i].city;
									}
								}
								$("#city").append(html);
								if(option!=''){
									$("#city").val(option).select2().change();
								}
							}else{
								layer.msg(json.msg);
							}
						}
					});
				})
			</script>
			<li>
				<label>市：</label>
				<form:select id="city" path="city" class="input-small">
				</form:select>
			</li>
			<script>
				$("#city").change(function(){
					$("#area").empty().val("<option value='' code=''>请选择区域</option>").select2();
					var code = $(this).find("option:selected").attr("code");
					$.ajax({
						url:'${ctxArea}',
						data: {city_code:code},
						async:true,
						loadFlag:true,
						type:'get',
						cache:false,
						success:function(json){
							if(json.rc==0){
								var html = "<option value='' code=''>请选择区域</option>";
								var option = "";
								var lists = json.items;
								for(var i = 0;i<lists.length;i++){
									html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
									if('${member.area}'==lists[i].area) {
										option = lists[i].area;
									}
								}
								$("#area").append(html);
								if(option!=''){
									$("#area").val(option).select2().change();
								}
							}else{
								layer.msg(json.msg);
							}
						}
					});
				})
			</script>
			<li>
				<label>区：</label>
				<form:select id="area" path="area" class="input-small">
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>姓名</th>
				<th>性别</th>
				<th>电话</th>
				<th>省</th>
				<th>市</th>
				<th>区</th>
				<th>会员截止日期</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
				</td>
				<td>
					${fns:getDictLabel(member.gender, 'user_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:escapeHtml(member.province)}
				</td>
				<td>
					${fns:escapeHtml(member.city)}
				</td>
				<td>
					${fns:escapeHtml(member.area)}
				</td>
				<td>
					<fmt:formatDate value="${member.memberEndDate}" pattern="yyyy-MM-dd"/>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>