<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作学校管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><shiro:hasPermission name="trainschool:handler:add"><a  href="${ctx}/trainschool/trainingInstitution/handlerForm"><button type="button" class="btn btn-primary">录入合作机构</button></a></shiro:hasPermission></li>
	</ul>
	<form:form id="searchForm" modelAttribute="trainingInstitution" action="${ctx}/trainschool/trainingInstitution/handlerSchoolList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>学校中文：</label>
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>学校类型：</label>
				<form:select path="firstSchoolType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="牵犬师培训学校"/>
					<form:option value="2" label="训犬师培训学校"/>
					<form:option value="3" label="营养师培训学校"/>
					<form:option value="4" label="综合性培训学校"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>学校中文</th>
				<th>负责人</th>
				<th>联系电话</th>
				<th>地址</th>
				<th>学校类型</th>
				<th>权限</th>
				<th>官网是否显示</th>
				<th>输送学员数</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="trainingInstitution">
			<tr>
				<td>
					${fns:unescapeHtml(trainingInstitution.schoolNameCn)}
				</td>
				<td>
					${fns:escapeHtml(trainingInstitution.responsibler)}
				</td>
				<td>
					${fns:escapeHtml(trainingInstitution.telephone)}
				</td>
				<td>
					${trainingInstitution.province}${trainingInstitution.city}${trainingInstitution.street }
				</td>
				<td>
					${fns:getDictLabel(trainingInstitution.firstSchoolType, 'first_school_type', '')}
				</td>
				<td>
					<c:if test="${trainingInstitution.endDate > date }">
						<font color="green">开放</font>
					</c:if>
					<c:if test="${trainingInstitution.endDate < date }">
						<font color="red">关闭</font>
					</c:if>
				</td>
				<td>
						${fns:getDictLabel(trainingInstitution.displayOnWeb, 'yes_no', '')}
				</td>
				<td>
					${trainingInstitution.student }
				</td>
				<td>
				    <a href="${ctx}/trainschool/trainingInstitution/handlerView?id=${fns:escapeHtml(trainingInstitution.id)}">查看</a>
				<shiro:hasPermission name="trainschool:handler:edit">
    				<a href="${ctx}/trainschool/trainingInstitution/handlerForm?id=${fns:escapeHtml(trainingInstitution.id)}">编辑</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="trainschool:handler:delete">
					<a href="${ctx}/trainschool/trainingInstitution/handlerDelete?id=${fns:escapeHtml(trainingInstitution.id)}" onclick="return confirmx('确认要删除该合作学校吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>