<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍名称变更管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function auditForm(id){
			parent.layer.open({
				type: 2,
				title: ['犬舍名称变更审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '600px'],
				content: "${ctx}/kennel/kennelRename/auditForm?id="+id,
				end:function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/kennel/kennelRename/">犬舍名称变更列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="kennelRename" action="${ctx}/kennel/kennelRename/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬舍名称：</label>
				<form:input path="originalNameCn" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
			<label>申请日期：&nbsp;</label><input id="beginDate" name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="<fmt:formatDate value="${kennelRename.beginDate}" pattern="yyyy-MM-dd"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			--<input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="<fmt:formatDate value="${kennelRename.endDate}" pattern="yyyy-MM-dd"/>" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬舍中文名</th>
				<th>犬舍英文名</th>
				<th>新犬舍中文名</th>
				<th>新犬舍英文名</th>
				<th>新FCI犬舍中文名</th>
				<th>备用FCI犬舍英文名</th>
				<th>犬舍所有人</th>
				<th>申请日期</th>
				<th>永久犬舍铜牌补做</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理</th>
<%--				<th>犬舍打印</th>
				<th>FCI打印</th>--%>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="kennelRename">
			<tr>
				<td>
					${fns:escapeHtml(kennelRename.originalNameCn)}
				</td>
				<td>
					${fns:escapeHtml(kennelRename.originalNameEn)}
				</td>
				<td>
					${fns:escapeHtml(kennelRename.newNameCn)}
				</td>
				<td>
					${fns:escapeHtml(kennelRename.newNameEn)}
				</td>
				<td>
					${fns:escapeHtml(kennelRename.fciKennel)}
				</td>
				<td>
					${fns:escapeHtml(kennelRename.fciKennelBackup)}
				</td>
				<td title="${fns:escapeHtml(kennelRename.memberCode)}">
					${fns:escapeHtml(kennelRename.member.name)}
				</td>
				<td>
					<fmt:formatDate value="${kennelRename.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>	
					<c:if test = "${'220.00' eq kennelRename.paymentMoney }">
						是
					</c:if>
					<c:if test = "${'120.00' eq kennelRename.paymentMoney }">
						否
					</c:if>
				</td>
				<td>
					<c:if test="${'1' eq kennelRename.paymentState}">
						<font color="red">${fns:getDictLabel(kennelRename.paymentState, 'user_payment_state', '')}</font>
					</c:if>
					<c:if test="${'2' eq kennelRename.paymentState}">
						<font color="green">${fns:getDictLabel(kennelRename.paymentState, 'user_payment_state', '')}</font>
					</c:if>
				</td>
				<td>
				<c:choose>
					<c:when test="${kennelRename.businessRefundState}">
						<a title="${fns:escapeHtml(kennelRename.reviewRemarks)}" >${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</a>
					</c:when>
					<c:when test="${'0' eq kennelRename.reviewState}">
						<shiro:hasPermission name="kennel:kennelRename:audit">
							<a href="#" onclick="auditForm('${fns:escapeHtml(kennelRename.id)}')"><font color="red">${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</font></a>
						</shiro:hasPermission>
						<shiro:lacksPermission name="kennel:kennelRename:audit">
							<font color="red">${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</font>
						</shiro:lacksPermission>
					</c:when>
					<c:when test="${'1' eq kennelRename.reviewState}">
						${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}
					</c:when>
					<c:when test="${'2' eq kennelRename.reviewState}">
					    <shiro:hasPermission name="kennel:kennelRename:audit">
						<a title="${fns:escapeHtml(kennelRename.reviewRemarks)}" onclick="auditForm('${fns:escapeHtml(kennelRename.id)}')">${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</a>
						</shiro:hasPermission>
					</c:when>
					<c:otherwise>
						<a title="${fns:escapeHtml(kennelRename.reviewRemarks)}" >${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</a>
					</c:otherwise>
				</c:choose>
				</td>
				
				
				<td>
					<c:choose>
						<c:when test="${'1' eq kennelRename.processState}">
							<font color="green">${fns:getDictLabel(kennelRename.processState, 'proccess_state', '')}</font>
						</c:when>
						<c:when test="${'2' eq kennelRename.paymentState and '1' eq kennelRename.reviewState}">
							<shiro:hasPermission name="kennel:kennelRename:resolve">
								<a href="${ctx}/kennel/kennelRename/resolve?id=${kennelRename.id}" onclick="return confirmx('确认要处理该犬舍名称变更吗？', this.href)">
									<font color="red">处理</font>
								</a>
							</shiro:hasPermission>
							<shiro:lacksPermission name="kennel:kennelRename:resolve">
								<font color="red">处理</font>
							</shiro:lacksPermission>
						</c:when>
						<c:otherwise>
							<font color="red">${fns:getDictLabel(kennelRename.processState, 'proccess_state', '')}</font>
						</c:otherwise>
					</c:choose>
				</td>
				
<%--				<td>
					<c:if test="${kennelRename.kennel.printState=='0' && kennelRename.paymentState=='2' && kennelRename.reviewState=='1' && kennelRename.processState=='1'}">
						<shiro:hasPermission name="kennel:kennel:print">
							<a href="${ctx}/kennel/kennel/print?id=${kennelRename.kennel.id}">打印</a>&nbsp;&nbsp;
						</shiro:hasPermission>
					</c:if>
					<c:if test="${kennelRename.kennel.printState=='1' && kennelRename.paymentState=='2' && kennelRename.reviewState=='1' && kennelRename.processState=='1'}">
						<shiro:hasPermission name="kennel:kennel:resetPrint">
							<a href="${ctx}/kennel/kennel/resetPrint?id=${kennelRename.kennel.id}&tz=1">重置打印</a>&nbsp;&nbsp;
						</shiro:hasPermission>
						<shiro:lacksPermission name="kennel:kennel:resetPrint">
							已打印
						</shiro:lacksPermission>
					</c:if>
				</td>
				<td>
					<c:if test="${kennelRename.kennel.fciPrintState=='0' && kennelRename.paymentState=='2' && kennelRename.reviewState=='1' && kennelRename.processState=='1'}">
						<shiro:hasPermission name="kennel:kennel:print">
							<a href="${ctx}/kennel/kennel/fciPrint?id=${kennelRename.kennel.id}">打印</a>&nbsp;&nbsp;
						</shiro:hasPermission>
					</c:if>
					<c:if test="${kennelRename.kennel.fciPrintState=='1' && kennelRename.paymentState=='2' && kennelRename.reviewState=='1' && kennelRename.processState=='1'}">
						<shiro:hasPermission name="kennel:kennel:resetPrint">
							<a href="${ctx}/kennel/kennel/fciResetPrint?id=${kennelRename.kennel.id}&tz=1">重置打印</a>&nbsp;&nbsp;
						</shiro:hasPermission>
						<shiro:lacksPermission name="kennel:kennel:resetPrint">
							已打印
						</shiro:lacksPermission>
					</c:if>
				</td>--%>
				
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>