<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-horizontal .control-label {
		    width: 110px!important;
		}
		.form-horizontal .controls {
		    margin-left: 100px;
		    margin-top: 3px;
		}
		.input-wate {
		    width: 163px;
		}
		.input-fill {
		    width: 80%;
		}
		.middle {
			width: 33.3%!important;
		}
		.cb label{
			margin-right: 10px;
		}
		.moreDogBreed{
		 	display: none;
		}
	</style>
	<script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			
			$("#btnSubmit").click(function(){
				
				//增加犬种重复判断
				var mainDogBreeds = [];
				mainDogBreeds.push($("#mainDogBreedFirst").val());
				mainDogBreeds.push($("#mainDogBreedSecond").val());
				mainDogBreeds.push($("#mainDogBreedThird").val());
				mainDogBreeds.push($("#mainDogBreedFourth").val());
				mainDogBreeds.push($("#mainDogBreedFifth").val());
				mainDogBreeds.push($("#mainDogBreedSixth").val());
				var refrainDogBreeds = refrain(mainDogBreeds);
				if(refrainDogBreeds.length>0){
					layer.msg("主营犬种设置重复，请修改后重试！");
					return ;	
				}
				
				$("#inputForm").ajaxSubmit({
			        dataType: 'json',
			        beforeSubmit: function(){
						if (!$("#inputForm").valid() || $(".error:visible").length > 0){
							return false;
						}
						else{
				            return true;
						}
			        },
			        success: function(data){
			            top.layer.msg(data.msg);
					    if(data.rc == 0){
							window.location = "${ctx}/kennel/kennel"
					    }
			        },  
			        error: function(err) { 
						top.layer.msg("操作失败!");           
			        }
				});
			});
			
			$("#addDogBreedBtn").click(function(){
				$(".moreDogBreed").show();
			});
		});
		
		//获取数组重复的元素
		function refrain(arr) {
		　　var tmp = [];
		　　if(Array.isArray(arr)) {
		　　　　arr.concat().sort().sort(function(a,b) {
		　　　　　　if(a != '' && b != '' && a != null && b != null && a==b && tmp.indexOf(a) === -1) tmp.push(a);
		　　　　});
		　　}
		　　return tmp;
		}
		
		function refresh(){
			location.reload(true);
		}
		
		$("#province").empty().val("").select2();
		$("#city").empty().val("").select2();
		$("#area").empty().val("").select2();
		//访问省市区域
		$.ajax({
			url:'${ctxProvince}',
			data: {},
			async:true,
			loadFlag:true,
			type:'get',
			cache:false,
			success:function(json){
				if(json.rc==0){
					var option = "";
					var html = "<option value='' code=''>请选择省份</option>";
					var lists = json.items;
					for(var i = 0;i<lists.length;i++){
						html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
						if('${kennel.province}'==lists[i].province) {
							option = lists[i].province;
						}
					}
					$("#province").append(html);
					if(option!=''){
						$("#province").val(option).select2().change();
					}
					else{
						$("#province").find("option").eq(0).prop("selected",true);
						$("#province").trigger("change");
					}
				}else{
					layer.msg(json.msg);
				}
			}
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/kennel/kennel">犬舍列表</a></li>
		<li class="active"><a href="${ctx}/kennel/kennel/editExtra/form?id=${kennel.id}">犬舍修改</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="kennel" action="${ctx}/kennel/kennel/saveExtra" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="bankCard"/>
		<sys:message content="${message}"/>
		<div class="control-group" style="width:100%">
			<label class="control-label"><h3>基本信息</h3></label>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.member.name)}
			</div>
		</div>
		
		<div class="control-group" style="float: left">
			<label class="control-label">犬舍状态：</label>
			<div class="controls">
				<c:if test="${kennel.endTime >= date}">
					已缴费
				</c:if>
				<c:if test="${empty kennel.endTime || kennel.endTime < date}">
					未缴费
				</c:if>
			</div>
		</div>
		<div class="control-group"  style="float: left">
			<label class="control-label">犬舍类型：</label>
			<div class="controls">
				${fns:getDictLabel(kennel.type, 'kennel_type', '')}
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬舍编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.kennelCode)}
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">FCI犬舍编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciKennelCode)}
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.name)}
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.nameEn)}
			</div>
		</div>
		
		<div class="control-group" >
			<label class="control-label">FCI英文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI备用英文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciNameBackup)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<fmt:formatDate value="${kennel.createDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<fmt:formatDate value="${kennel.endTime}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group" style="width:100%">
			<label class="control-label"><h3>营业信息</h3></label>
		</div>
		<div class="control-group" style="width:100%">
			<label class="control-label">犬舍地址：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-wate">
				</form:select>&nbsp;&nbsp;&nbsp;
				<form:select id="city" path="city" class="input-wate">
				</form:select>&nbsp;&nbsp;&nbsp;
				<form:select id="area" path="area" class="input-wate">
				</form:select>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var option = "";
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
								if('${kennel.city}'==lists[i].city) {
									option = lists[i].city;
								}
							}
							$("#city").append(html);
							if(option!=''){
								$("#city").val(option).select2().change();
							}
							else{
								$("#city").find("option").eq(0).prop("selected",true);
								$("#city").trigger("change");
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
			$("#city").change(function(){
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var option = "";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
								if('${kennel.area}'==lists[i].area) {
									option = lists[i].area;
								}
							}
							$("#area").append(html);
							if(option!=''){
								$("#area").val(option).select2().change();
							}
							else{
								$("#area").find("option").eq(0).prop("selected",true);
								$("#area").trigger("change");
							}
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group" style="width:100%">
			<label class="control-label">详细地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" maxlength="200" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group" style="width:100%">
			<label class="control-label">营业电话：</label>
			<div class="controls">
				<form:input path="businessTelephone" htmlEscape="false" maxlength="20" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group cb" style="width:100%">
			<label class="control-label">营业时间：</label>
			<div class="controls">
				<form:checkboxes path="businessDaysArr" items="${fns:getDictList('business_days')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				<form:input path="openingTime" type="text" class="input-wate Wdate " readonly="true"
					onclick="WdatePicker({dateFmt:'HH:mm',isShowClear:true});"/>
				<form:input path="closingTime" type="text" class="input-wate Wdate " readonly="true"
				onclick="WdatePicker({dateFmt:'HH:mm',isShowClear:true});"/>
			</div>
		</div>
		</div>
		<div class="control-group middle">
			<label class="control-label">主营品种一：</label>
			<div class="controls">
				<form:select path="mainDogBreedFirst" class="input-fill">
                    <form:option value="" label="请选择"/>
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		<div class="control-group middle">
			<label class="control-label">主营品种二：</label>
			<div class="controls">
				<form:select path="mainDogBreedSecond" class="input-fill">
                    <form:option value="" label="请选择"/>
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		<div class="control-group middle">
			<label class="control-label">主营品种三：</label>
			<div class="controls">
				<form:select path="mainDogBreedThird" class="input-fill">
                    <form:option value="" label="请选择"/>
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
                </form:select>
                <img id="addDogBreedBtn" alt="添加" style="width:26px;;height:26px;margin-left: 5px;cursor:pointer; " src="${ctxStatic}/images/add.png">
			</div>
		</div>
		<c:if test="${!empty kennel.mainDogBreedFourth || !empty kennel.mainDogBreedFifth || !empty kennel.mainDogBreedSixth}">
		<div>
		</c:if>
		<c:if test="${empty kennel.mainDogBreedFourth && empty kennel.mainDogBreedFifth && empty kennel.mainDogBreedSixth}">
		<div class="moreDogBreed">
		</c:if>
			<div class="control-group middle">
				<label class="control-label">主营品种四：</label>
				<div class="controls">
					<form:select path="mainDogBreedFourth" class="input-fill">
	                    <form:option value="" label="请选择"/>
	                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
	                </form:select>
				</div>
			</div>
			<div class="control-group middle">
				<label class="control-label">主营品种五：</label>
				<div class="controls">
					<form:select path="mainDogBreedFifth" class="input-fill">
	                    <form:option value="" label="请选择"/>
	                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
	                </form:select>
				</div>
			</div>
			<div class="control-group middle">
				<label class="control-label">主营品种六：</label>
				<div class="controls">
					<form:select path="mainDogBreedSixth" class="input-fill">
	                    <form:option value="" label="请选择"/>
	                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
	                </form:select>
				</div>
			</div>
		</div>
		<div class="control-group" style="width:100%">
			<label class="control-label">犬舍介绍：</label>
			<div class="controls">
				<form:textarea path="introduction" htmlEscape="false" maxlength="900" class="input-xlarge"
						cssStyle="height:100px"/>
			</div>
		</div>
		<div class="control-group" style="width:100%">
			<label class="control-label">营业照片：</label>
			<div class="controls">
				<sys:multiImageUpload fileNumLimit="3" fileSizeLimit="1024*1024*10" fileSingleSizeLimit="1024*1024*1" 
					images="${kennel.kennelImageList}" successCallback="uploadSuccess"/>
				<form:hidden path="kennelImages"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(images){
						$("#kennelImages").val(images);
					}
				</script>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>&nbsp;
			<input id="btnRefresh" class="btn" type="button" value="刷新" onclick="refresh()"/>
		</div>
	</form:form>
</body>
</html>