<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>在册牵犬师管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handler/view?id=${handler.id}">在册牵犬师查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handler" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				${handler.name }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">网站会员：</label>
			<div class="controls">
				${handler.webMembershipCode }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${handler.memberCode }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				${handler.gender }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份证号：</label>
			<div class="controls">
				${handler.identityCard }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">详细地址：</label>
			<div class="controls">
				${handler.address }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系电话：</label>
			<div class="controls">
				${handler.telephone }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书号：</label>
			<div class="controls">
				${handler.certificateCode }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮政编码：</label>
			<div class="controls">
				${handler.postcode }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">申请资格：</label>
			<div class="controls">
				${handler.qualification }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">资格说明：</label>
			<div class="controls">
				${handler.qualificationDetil }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核人：</label>
			<div class="controls">
				${handler.reviewer }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				${handler.remarks }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				${fns:getDictLabels(handler.reviewState, 'review_state', '')}
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>