<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容组合套餐</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出美容组合套餐报名信息表数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/groomer/groomerPackage/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/groomer/groomerPackage/");
			$("#searchForm").submit();
        	return false;
        }
		//上传证件照
		function openLayer2(id){
			top.layer.open({
				type: 2,
				title: ['查看照片', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['1000px', '800px'],
				content: "${ctx}/groomer/groomerPackage/toUpImage?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		
		
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerPackage/">报名信息</a></li>
		<li><a href="${ctx}/groomer/groomerPackage/grade">成绩管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerPackage" action="${ctx}/groomer/groomerPackage/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><span><label>会员号/姓名：</label></span>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li> 
			<li>
				<label>报名时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerPackage.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerPackage.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			<li class="btns">
			     <input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<button id="btnExport" type="button" class="btn btn-primary" >导出</button>
			
			</li>
			
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>支付时间</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>美容师类型</th>
				<th>移动电话</th>
				<th>性别</th>
				<th>培训学校</th>
				<th>比赛犬种</th>
				<th>赛事级别</th>
				<th>缴费</th>
				<th>照片</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerPackage">
			<tr>
				<td>
					${fns:escapeHtml(groomerPackage.applyCode)}
				</td>
				<td>	
					<fmt:formatDate value="${groomerPackage.paymentTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td title='${fn:replace(groomerPackage.memberCode, ",", "  ")}'>
					<a href="${ctx}/sys/user/member/form?id=${groomerPackage.member.id}">
					${fns:escapeHtml(groomerPackage.memberCode)}
					</a>
				</td>
				<td>
					${fns:escapeHtml(groomerPackage.name)}
				</td>
				<td>
					${fns:getDictLabels(groomerPackage.member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					${fns:escapeHtml(groomerPackage.member.mobile)}
				</td>
				<td>
					${fns:getDictLabel(groomerPackage.member.gender, 'user_gender', '')}
				</td>
				<td>
					${fn:replace(groomerPackage.schoolNameCn, ",", "  ")}
				</td>
				
				<td>
					${fns:escapeHtml(groomerPackage.dogBreed)}
				</td>
				<td>
						${groomerPackage.showLevel }
				</td>
				<td>
					     ${fns:getDictLabel(groomerPackage.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<a href="#" onclick="openLayer2('${fns:escapeHtml(groomerPackage.id)}')">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>