<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书换发申请</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					if("${dogPedigreeCertifiedChange.paymentChargingItemId}" == "326" && !$("#overseasPedigreeCertified").val().toLowerCase().startsWith("cku")){
						$.jBox.error("仅限输入CKU血统证书号！","系统提示");
						$("#overseasPedigreeCertified").val("");
						return false;
					}
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/add',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("订单录入成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("提交失败,错误信息："+data.msg);
 						} 
 				    });
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			
			$("#overseasPedigreeCertified").blur(function(){
				if("${dogPedigreeCertifiedChange.paymentChargingItemId}" == "326" && $(this).val() != "" && !$(this).val().toLowerCase().startsWith("cku")){
					$.jBox.error("仅限输入CKU血统证书号！","系统提示");
					$("#overseasPedigreeCertified").val("");
				}
				
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}

		function getDogColorMarkByDogBreed(){
			var dogBreedCode = $("#dogBreed").val();
			$.post('${ctx}/dogcolormark/dogColorMark/getByDogBreed', {
				dogBreedCode: dogBreedCode
			}, function(data) {
				$('#dogFurColor').empty();
				$('#dogFurColor').append("<option value=''>请选择毛色</option>");
				$.each(data, function(i,val) {
					$('#dogFurColor').append("<option value ='"+val.dogColorMarkCode+"'>"+val.dogColorMarkCn+"</option>");
				});
				$("#dogFurColor").trigger("change");
			});
		}

		function getOrgByProvince(){
			var province = $("#province").val();
			if(province=='赛场'){
				$('#orgId').empty();
				$('#orgId').append("<option value ='赛场换发'>赛场换发</option>");
			}else{
				$.post('${ctx}/sys/org/getOrg', {
					province: province,
					oaOrder: 'oaOrder'
				}, function(data) {
					$('#orgId').empty();
					$('#orgId').append("<option value =''>选择合作机构</option>");
					$.each(data, function(i,val) {
						$('#orgId').append("<option value ='"+val.id+"'>"+val.name+"</option>");
					});
				});
			}
		}

	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogPedigreeCertifiedChange" class="form-horizontal">
	<form:hidden path="paymentMemberCode"/>
	<form:hidden path="paymentChargingItemId"/>
	<form:hidden path="runningNumber"/>
	<div class="control-group">
		<label class="control-label">犬种：</label>
		<div class="controls">
			<form:select path="dogBreed" class="input-xlarge required" onchange="getDogColorMarkByDogBreed()">
				<form:option value="" label="选择犬种"/>
				<form:options items="${dogTypeList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">所属协会：</label>
		<div class="controls">
			<form:select path="association" class="input-xlarge required">
				<option value="">选择所属协会</option>
				<form:options items="${associationList}" itemLabel="name" itemValue="code" htmlEscape="false"/>
				<option value="NGKC">中国-NGKC</option>
			</form:select>
<%--			<select name="association" class="input-large required">
				<option value="">选择所属协会</option>
				<option value="VKA">越南-VKA</option>
				<option value="FCA">阿根廷-FCA</option>
				<option value="EST">爱沙尼亚-EST</option>
				<option value="ANKC">澳大利亚-ANKC</option>
				<option value="KP">巴基斯坦-KP</option>
				<option value="CBC">巴西-CBC</option>
				<option value="BCU">白俄罗斯-BCU</option>
				<option value="PK">保加利亚-PK</option>
				<option value="LOSH">比利时-LOSH</option>
				<option value="BHR">波黑-BHR</option>
				<option value="ZKP">波兰-ZKP</option>
				<option value="KCB">玻利维亚-KCB</option>
				<option value="DKK">丹麦-DKK</option>
				<option value="VDH">德国-VDH</option>
				<option value="RKF">俄罗斯-RKF</option>
				<option value="LOF">法国-LOF</option>
				<option value="PCC">菲律宾-PCC</option>
				<option value="LOC">哥伦比亚-LOC</option>
				<option value="ROK">韩国-ROK</option>
				<option value="NHSB">荷兰-NHSB</option>
				<option value="MNE">黑山-MNE</option>
				<option value="CKC">加拿大-CKC</option>
				<option value="CKS">捷克-CKS</option>
				<option value="HR">克罗地亚-HR</option>
				<option value="LSVK">立陶宛-LSVK</option>
				<option value="COR">罗马尼亚-COR</option>
				<option value="MKC">马耳他-MKC</option>
				<option value="MKA">马来西亚-MKA</option>
				<option value="MR">马其顿-MR</option>
				<option value="AKC">美国-AKC</option>
				<option value="FCM">墨西哥-FCM</option>
				<option value="N">挪威-N</option>
				<option value="LOP">葡萄牙-LOP</option>
				<option value="JKC">日本-JKC</option>
				<option value="SE">瑞典-SE</option>
				<option value="SHSB">瑞士-SHSB</option>
				<option value="JR">塞尔维亚-JR</option>
				<option value="SPKP">斯洛伐克-SPKP</option>
				<option value="SLR">斯洛文尼亚-SLR</option>
				<option value="KCT">台湾-KCT</option>
				<option value="KATH">泰国-KATH</option>
				<option value="FCV">委内瑞拉-FCV</option>
				<option value="UKU">乌克兰-UKU</option>
				<option value="LOE">西班牙-LOE</option>
				<option value="BEK">希腊-BEK</option>
				<option value="HKKC">香港-HKKC</option>
				<option value="MET">匈牙利-MET</option>
				<option value="LOI">意大利-LOI</option>
				<option value="KCI">印度-KCI</option>
				<option value="KC">英国-KC</option>
				<option value="KCC">智利-KCC</option>
				<option value="CYA">塞浦路斯-CYA</option>
				<option value="IKC">爱尔兰-IKC</option>
				<option value="KIF">土耳其-KIF</option>
            </select>--%>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">性别：</label>
		<div class="controls">
			<form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">外国证书号：</label>
		<div class="controls">
			<form:input path="overseasPedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬名：</label>
		<div class="controls">
			<form:input path="dogName" htmlEscape="false" maxlength="64" class="input-xlarge required dogName "/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">芯片号码：</label>
		<div class="controls">
			<form:input path="dogChip" htmlEscape="false" maxlength="64" class="input-xlarge"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">毛色：</label>
		<div class="controls">
			<form:select id="dogFurColor" path="dogFurColor" class="input-xlarge required">
				<form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">出生日期：</label>
		<div class="controls">
			<input name="dogBirthday" type="text" readonly="readonly" maxlength="20" class="input-xlarge Wdate required"
			 value="" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">合作机构：</label>
		<div class="controls">
			<form:select path="province" class="input-medium required" onchange="getOrgByProvince()">
				<form:option value="" label="选择地区"/>
				<form:option value="赛场" label="赛场"/>
				<form:options items="${provinceList}" itemLabel="name" itemValue="name" htmlEscape="false"/>
			</form:select>
			<form:select path="orgId" class="input-xlarge required">
				<form:option value="" label="选择合作机构"/>
			</form:select>
		</div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>