package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.service.DogSemenService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只精子Controller
 *
 * @author lgl
 * @version 2017-08-28
 */
@Controller
@RequestMapping(value = "/subSystem/dogSemen")
public class SubDogSemenController extends BaseController {

    @Autowired
    private DogSemenService dogSemenService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
    @ModelAttribute
    public DogSemen get(@RequestParam(required = false) String id) {
        DogSemen entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogSemenService.get(id);
        }
        if (entity == null) {
            entity = new DogSemen();
        }
        return entity;
    }

    @RequestMapping(value = {"list", ""})
    public String list(DogSemen dogSemen, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogSemen> page = dogSemenService.findPage(new Page<DogSemen>(request, response), dogSemen);
        model.addAttribute("page", page);
        return "subSystem/"+getUrlByUserType()+"/dog/dogsemen/dogSemenList";
    }

    @RequestMapping(value = "form")
    public String form(DogSemen dogSemen, Model model) {
        model.addAttribute("dogSemen", dogSemen);
        return "subSystem/"+getUrlByUserType()+"/dog/dogsemen/dogSemenForm";
    }
}