package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogPedigreeCertifiedRedo;
import com.cku.oa.dog.service.DogPedigreeCertifiedRedoService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 证书补做Controller
 * @author lgl
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/subSystem/dogPedigreeCertifiedRedo")
public class SubDogPedigreeCertifiedRedoController extends BaseController {

	@Autowired
	private DogPedigreeCertifiedRedoService dogPedigreeCertifiedRedoService;
	@Autowired
	private DogService dogService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public DogPedigreeCertifiedRedo get(@RequestParam(required=false) String id) {
		DogPedigreeCertifiedRedo entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogPedigreeCertifiedRedoService.get(id);
		}
		if (entity == null){
			entity = new DogPedigreeCertifiedRedo();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogPedigreeCertifiedRedo> page = dogPedigreeCertifiedRedoService.findPage(new Page<DogPedigreeCertifiedRedo>(request, response), dogPedigreeCertifiedRedo); 
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoList";
	}

	@RequestMapping(value = "form")
	public String form(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, Model model) {
		model.addAttribute("dogPedigreeCertifiedRedo", dogPedigreeCertifiedRedo);
		return "subSystem/"+getUrlByUserType()+"/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoForm";
	}
}