/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.show.entity.ChampionLogin;
import com.cku.oa.show.service.ChampionLoginService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/**
 * 冠军登录Controller
 * @author zhuoHeng
 * @version 2016-07-14
 */
@Controller
@RequestMapping(value = "/subSystem/championLogin")
public class SubChampionLoginController extends BaseController {

	@Autowired
	private ChampionLoginService championLoginService;
	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private DogService dogService;
	@Autowired
	private LoginServerService loginServerService;


	@ModelAttribute
	public ChampionLogin get(@RequestParam(required=false) String id) {
		ChampionLogin entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = championLoginService.get(id);
		}
		if (entity == null){
			entity = new ChampionLogin();
		}
		return entity;
	}
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	/**
	 * 
	 * @Description：冠军登录列表查询
	 * @author: zhuoHeng
	 * @version: 2016年7月14日 下午3:29:51
	 */
	@RequestMapping(value = {"list", ""})
	public String list(ChampionLogin championLogin, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ChampionLogin> page = championLoginService.findPage(new Page<ChampionLogin>(request, response), championLogin);
		for(ChampionLogin vo:page.getList()){
			vo.setIsHaveDogDna(dogDnaService.isHaveDogDna(vo.getDog().getId())?"是":"否");
		}
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/championlogin/championLoginList";
	}

	/**
	 * 
	 * @Description：进入冠军登录编辑界面
	 * @author: zhuoHeng
	 * @version: 2016年7月14日 下午3:30:16
	 */
	@RequestMapping(value = "view")
	public String form(ChampionLogin championLogin, Model model) {
		model.addAttribute("championLogin", championLogin);
		return "subSystem/"+getUrlByUserType()+"/dog/championlogin/championLoginView";
	}

}