package com.cku.schools.mrschool.service;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.Date;
import java.util.UUID;

import org.springframework.web.multipart.MultipartFile;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;

public class OSSUtils {
	// Endpoint以杭州为例，其它Region请按实际情况填写。
	private static String endpoint = "http://oss-cn-qingdao.aliyuncs.com";
	// 阿里云主账号AccessKey拥有所有API的访问权限，风险很高。强烈建议您创建并使用RAM账号进行API访问或日常运维，请登录
	// https://ram.console.aliyun.com 创建RAM账号。
	private static String accessKeyId = "LTAI4G2pXAQFor2iDgLyp55L";
	private static String accessKeySecret = "EkqgTsxoM5y3nppudUAD2fn7dPc8OC";
	private static String roleArn = "acs:ram::1563167182185477:role/ckuoavideorole";
	private static String roleSessionName = "groomer";
	private static String stsEndpoint = "sts.cn-qingdao.aliyuncs.com";
	// 创建OSSClient实例。
	private static OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

	/**
	 * 上传 这个方法不通用，限制了存放桶和位置
	 * 
	 * @param file
	 * @return
	 * @throws Exception
	 */
	public static String upload(MultipartFile file) throws Exception {

		// 上传Byte数组。
		byte[] content = file.getBytes();
		String newFileName = UUID.randomUUID()
				+ file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
		ossClient.putObject("groomer-course", newFileName, new ByteArrayInputStream(content));
		// 关闭OSSClient。
		// ossClient.shutdown();
		return newFileName;
	}

	/**
	 * 获取访问URL 这个方法不通用，限制了存放桶和位置
	 * 
	 * @param vodName
	 * @return
	 */
	public static String getVodUrl(String vodName) {
		// 设置URL过期时间为1小时。
		Date expiration = new Date(new Date().getTime() + 3600 * 1000);
		// 生成以GET方法访问的签名URL，访客可以直接通过浏览器访问相关内容。
		URL url = ossClient.generatePresignedUrl("groomer-course", vodName, expiration);
		return url.toString();
	}

	public static AssumeRoleResponse getStsToken() throws Exception {
		// 添加endpoint（直接使用STS endpoint，前两个参数留空，无需添加region ID）
		DefaultProfile.addEndpoint("", "", "Sts", stsEndpoint);
		// 构造default profile（参数留空，无需添加region ID）
		IClientProfile profile = DefaultProfile.getProfile("", accessKeyId, accessKeySecret);
		// 用profile构造client
		DefaultAcsClient client = new DefaultAcsClient(profile);
		final AssumeRoleRequest request = new AssumeRoleRequest();
		request.setMethod(MethodType.POST);
		request.setRoleArn(roleArn);
		request.setRoleSessionName(roleSessionName);
		request.setPolicy(null); // 若policy为空，则用户将获得该角色下所有权限
		request.setDurationSeconds(1800L); // 设置凭证有效时间
		return client.getAcsResponse(request);

	}
}
