package com.cku.restful.v1.show.web;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.restful.v1.show.service.CKUShowReportInfoService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping(value = "/cku/v1/shows/reportInfo")
public class CKUShowReportInfoController {
	@Autowired
	private CKUShowReportInfoService showReportInfoService;

	@RequestMapping(value = "/getChildListByMainId", method = RequestMethod.GET)
	@ResponseBody
	public void getChildListByMainId(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = showReportInfoService.getChildListByMainId(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getShowReportInfoById", method = RequestMethod.GET)
	@ResponseBody
	public void getShowReportInfoById(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = showReportInfoService.getShowReportInfoById(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/look", method = RequestMethod.GET)
	@ResponseBody
	public void look(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = showReportInfoService.look(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getShowReportAllScoreById", method = RequestMethod.GET)
	@ResponseBody
	public void getShowReportAllScoreById(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		String group = request.getParameter("group");
		if (StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "犬展场次信息有误，请重试");
		}
		if (StringUtils.isBlank(group)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "犬展组别信息有误，请重试");
		}
		RESTResponse result = showReportInfoService.getShowReportAllScoreById(id, group);
		ServletUtils.writeResponse(response, result);
	}
}
