
package com.cku.restful.v1.dogNoseprin.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.dogNoseprin.entity.DogNoseRaffle;
import com.cku.restful.v1.dogNoseprin.entity.DogNoseRaffleRecord;
import com.cku.restful.v1.dogNoseprin.service.DogNoseRaffleRecordService;
import com.cku.restful.v1.dogNoseprin.service.DogNoseRaffleService;
import com.cku.restful.v1.dogNoseprin.vo.DogNoseRaffleRecordVO;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import net.sf.json.JSONObject;

/**
 * 
 * @author xx
 *
 */
@Api(value = "手机App 鼻纹抽奖-xuxue", tags = { "手机App 鼻纹抽奖-xuxue" })
@Controller
@RequestMapping(value = "/api/v1/dogNoseprin/raffle")
public class DogNoseprinTraffleController extends BaseRestController {

	@Autowired
	private DogNoseRaffleService dogNoseRaffleService;

	@Autowired
	private DogNoseRaffleRecordService dogNoseRaffleRecordService;

	/**
	 * 第一次分享增加抽奖机会,多次调用不影响结果
	 * 
	 * @param json
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "第一次分享增加抽奖机会,多次调用不影响结果", notes = "")
	@RequestMapping(value = "share", method = RequestMethod.POST)
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + " \"rc\": 0,\n" + "\"msg\": \"OK\"\n" + "}\n" + ""))
	public void share(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, dogNoseRaffleService.share());

	}

	/**
	 * 我的中奖记录
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "我的中奖记录")
	@RequestMapping(value = "my/records", method = RequestMethod.GET)
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + " \"rc\": 0,\n" + "\"msg\": \"OK\",\n" + " \"data\": [\n"
			+ " {\n" + " \"memberCode\": \"2268\",\n" + " \"couponName\": \"5元\", -- 奖品信息\n"
			+ " \"memberName\": \"信息\", -- 会员名称\n" + " \"couponId\": \"1\",\n"
			+ " \"createDate\": \"2020-10-10 00:00:00\" --中奖时间\n" + " }\n" + " ]\n" + "}"))
	public void myRecords(HttpServletRequest request, HttpServletResponse response) throws IOException {
		DogNoseRaffleRecord dogNoseRaffleRecord = new DogNoseRaffleRecord();
		dogNoseRaffleRecord.setDelFlag("0");
		dogNoseRaffleRecord.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		List<DogNoseRaffleRecord> list = dogNoseRaffleRecordService.findList(dogNoseRaffleRecord);
		List<DogNoseRaffleRecordVO> l = new ArrayList<>();
		for (DogNoseRaffleRecord t : list) {
			DogNoseRaffleRecordVO v = new DogNoseRaffleRecordVO();
			BeanUtils.copyProperties(t, v);
			l.add(v);
		}
		ServletUtils.writeResponse(response, new RESTResponse("data", l));
	}

	@ApiOperation(value = "我的抽奖次数")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + " \"rc\": 0,\n" + " \"msg\": \"OK\",\n" + " \"data\": {\n"
			+ " \"totalNum\": 3, -- 总次数\n" + " \"usedNum\": 0 --已用次数\n" + " }\n" + "}\n" + ""))
	@RequestMapping(value = "my/total", method = RequestMethod.GET)
	public void total(HttpServletRequest request, HttpServletResponse response) throws IOException {
		DogNoseRaffle raffle = dogNoseRaffleService.getOneByMemberCode(UserUtils.getLoginMember().getMemberCode());
		JSONObject json = new JSONObject();
		if (raffle != null) {
			json.put("totalNum", raffle.getTotalNum());
			json.put("usedNum", raffle.getUsedNum());
		} else {
			json.put("totalNum", 0);
			json.put("usedNum", 0);
		}
		ServletUtils.writeResponse(response, new RESTResponse("data", json));
	}

	/**
	 * 抽奖
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "抽奖")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + " \"rc\": 0,\n" + "\"msg\": \"OK\",\n" + " \"data\": {\n"
			+ " \"prizeName\": \"20元代金券\", -- 奖品名字\n" + "\"facePrice\": 20,-- 面值\n"
			+ " \"prizeCode\": 9 -- 奖品转盘的位置，已与前端约定好\n" + " }\n" + "}\n" + ""))
	@RequestMapping(value = "participate", method = RequestMethod.GET)
	public void participate(HttpServletRequest request, HttpServletResponse response) throws IOException {
		Member member = UserUtils.getLoginMember();
		ServletUtils.writeResponse(response, dogNoseRaffleService.participate(member));
	}

}