/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import java.io.IOException;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogBirthCertificateService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 出生证明Controller
 *
 * @author lgl
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogBirthCertificateController extends BaseRestController {

	@Autowired
	private RestDogBirthCertificateService birthCertificateService;

	@RequestMapping(value = "/birthcertificate/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void get(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate/getByBirthCerRegCode", method = RequestMethod.GET)
	@ResponseBody
	public void getBySnCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.getByBirthCerRegCode(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate/getByIdentificationFlag", method = RequestMethod.GET)
	@ResponseBody
	public void getByIdentificationFlag(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.getByIdentificationFlag(request);
		if(Objects.nonNull(result.getData()) && Objects.nonNull(result.getData().getJSONObject("data"))) {
			result.getData().getJSONObject("data").put("currentMemberCode", UserUtils.getLoginMember().getMemberCode());
		}
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void delete(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.delete(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate", method = RequestMethod.PUT)
	@ResponseBody
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate", method = RequestMethod.POST)
	@ResponseBody
	public void postBirthcertificate(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = birthCertificateService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate/randomName", method = RequestMethod.GET)
	@ResponseBody
	public void getRandomName(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.getRandomName(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @Description：根据父母犬配种证明编号查询该配种证明下出生纸信息
	 * @author: zhuoHeng
	 * @version: 2016年11月9日 下午3:11:17
	 */
	@RequestMapping(value = "/birthcertificate/getByBreedCertifiedCode", method = RequestMethod.GET)
	@ResponseBody
	public void getByBreedCertifiedCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.getByBreedCertifiedCode(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 幼犬出生日期校验
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	@RequestMapping(value = "/birthcertificate/checkDogBirthday", method = RequestMethod.GET)
	@ResponseBody
	public void checkDogBirthday(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.checkDogBirthday(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 幼犬出生日期校验 同意返回值
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	@RequestMapping(value = "/birthcertificate/checkDogBirthday1", method = RequestMethod.GET)
	@ResponseBody
	public void checkDogBirthday1(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.checkDogBirthday1(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 同胞犬数校验
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	@RequestMapping(value = "/birthcertificate/checkSameBatchNum", method = RequestMethod.GET)
	@ResponseBody
	public void checkSameBatchNum(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.checkSameBatchNum(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 获取加急费是否能免费的标记位
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	@RequestMapping(value = "/birthcertificate/getUrgentFreeFlag", method = RequestMethod.GET)
	@ResponseBody
	public void getUrgentFreeFlag(HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.getUrgentFreeFlag();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 会员犬舍校验
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	@RequestMapping(value = "/birthcertificate/checkMemberKennel", method = RequestMethod.GET)
	@ResponseBody
	public void checkMemberKennel(HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.checkMemberKennel();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 犬名校验
	 * @author: laiguanglong
	 * @date: 2017/5/17 16:33
	 */
	@RequestMapping(value = "/birthcertificate/checkDogName", method = RequestMethod.GET)
	@ResponseBody
	public void checkDogName(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = birthCertificateService.checkDogName(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/birthcertificate/addDogNose", method = RequestMethod.PUT)
	@ResponseBody
	public void addDogNose(@RequestBody String json, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, birthCertificateService.addDogNose(json));
	}
}