package com.cku.partner.open.sys.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.util.MD5Generator;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.security.UsernamePasswordToken;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional(readOnly = true)
public class AppLoginService {

    @Autowired
    private UserDao userDao;
    @Autowired
    private SystemService systemService;
    @Autowired
    private OrgService orgService;
    /**
     *
     * @description: 登录
     * @author: laiguanglong
     * @date: 2016年9月25日 下午1:27:06
     */
    @Transactional(readOnly = false)
    public void login(String loginName, String password, String host, String loginType){
        //俱乐部站点
        String userType="3";

        if(StringUtils.isBlank(loginName)){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
        }
        if(StringUtils.isBlank(password)){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码不能为空");
        }
        //合作机构sys_user_type为3：合作机构
        User user = systemService.getUserByLoginNameAndUserType(loginName, userType);
        if (user == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
        }
        if (!user.getPassword().equals(MD5Generator.generate16(password))) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
        }
        //判断账号是否过期
        //合作机构可不可用是判断合作机构的截止时间
        Org org = new Org();
        org.setUser(user);
        List<Org> orgs = orgService.findList(org);
        if(orgs.size() == 1){
            if(orgs.get(0).getEndDate().getTime()<System.currentTimeMillis()){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号已经过期，请联系CKU处理");
            }
        }else{
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号信息有误，请联系CKU处理");
        }

        //将用户信息存放到登录信息里
        UsernamePasswordToken token = new UsernamePasswordToken(loginName, password.toCharArray(), userType, false, host, "", false, loginType);

        SecurityUtils.getSubject().login(token);

    }
}
