package com.cku.partner.open.club.web;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.partner.open.club.service.AppHospitalService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thinkgem.jeesite.common.utils.DateUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import io.swagger.annotations.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Controller
@RequestMapping(value = "/partner/open/finance")
public class RestClubFinanceController extends BaseRestController  {

	@Autowired
	private MemberService memberService;
	
	@Autowired
	private RestOrderService restOrderService;
	
	@Autowired
	private PaymentCartService paymentCartService;
	
	@Autowired
	private PaymentOrderService paymentOrderService;
	
	@Autowired
	private ShopOrderService shopOrderService;
	
	private ObjectMapper objectMapper = new ObjectMapper();

	@Autowired
	private AppHospitalService appHospitalService;
	
	@ApiOperation(value = "club下单", tags = { "club支付" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\r\n" + "    \"rc\": 0,\r\n" + "    \"msg\": \"OK\",\r\n"
			+ "    \"data\": {\r\n" + "        \"id\": \"e36310e9d00e4708a15c1575ce8c4cb7\"\r\n" + "    }\r\n" + "}") })
	@RequestMapping(value = "/order", method = RequestMethod.POST)
	@ResponseBody
	public void cartToOrder(@ApiParam(name = "json", value = "{\r\n" + "	\"del\": \"13333333333\",\r\n"
			+ "	\"receiverAddress\": \"漷县镇侯黄庄村606号海润犬舍\",\r\n"
			+ "	\"carts\": [\"6b7e3bdad8e34da8ab52bc2bb02c0bf9\",\"f3406b92e4f740e78e11fb9f8e44de16\"],\r\n"
			+ "	\"receiver\": \"刘载春\",\r\n" + "\"memberCode\": \"2268\",\r\n"  +  "\"postcode\": \"101112\",\r\n" + "	\"receiverCity\": \"北京市\",\r\n"
			+ "	\"receiverProvince\": \"北京市\"\r\n" + "}") @RequestBody String json, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		JSONArray carts = object.getJSONArray("carts");
		
		Object[] ids = carts.toArray();
		PaymentOrder order = new PaymentOrder();
		order.setReceiveProvince(object.getString("receiverProvince"));
		order.setReceiveCity(object.getString("receiverCity"));
		if (object.get("receiverArea") == null) {
			order.setReceiveArea("");
		} else {
			order.setReceiveArea(object.get("receiverArea").toString());
		}
		order.setReceiveAddress(object.getString("receiverAddress"));
		String postcode = (String) object.get("postcode");
		order.setReceivePostCode(postcode);
//		order.setReceivePostCode(object.getString("postcode"));
		order.setReceiveDel(object.getString("del"));
		order.setReceiver(object.getString("receiver"));
		
		//String memberCode = object.getString("memberCode");

		Member loginMember = appHospitalService.loginMember();
		if (loginMember == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号错误");
		}
		order.setMemberCode(loginMember.getMemberCode());
		order.setMemberName(loginMember.getName());
		// 如果使用优惠券，减去相应的金额
		String couponId = null;
		if (object.get("couponId") != null) {
			couponId = object.getString("couponId");
		}
		String id = restOrderService.cartToOrderClub(ids, order, couponId);
		JSONObject jo = new JSONObject();
		jo.put("id", id);
		ServletUtils.writeResponse(response, new RESTResponse("data", jo));
	}
	
	
	
	@ApiOperation(value = "club获取价格", tags = { "club支付" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value = "/calculate", method = RequestMethod.POST)
	@ResponseBody
	public void calculate(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		JSONArray carts = object.getJSONArray("carts");// 购物车记录的ID
		
		List<String> ids = Arrays.asList(carts.toArray());
		String couponId = null;
		if (object.get("couponId") != null) {
			couponId = object.getString("couponId");
		}
		// 计算总价
		RESTResponse result = new RESTResponse("data", paymentCartService.totalPricseClub(ids, couponId).getTotalPrice());
		ServletUtils.writeResponse(response, result);
	}
	
	
	/**
	 *
	 * @Description：根据购物车ids获取登录人购物车中对应id的记录
	 * @author: zhuoHeng
	 * @version: 2016年12月16日 下午4:34:45
	 */
	@ApiOperation(value = "club查询购物车", tags = { "club支付" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "cartIds", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "source", paramType = "query", value = "cooperator")})
	@ApiResponses({ @ApiResponse(code = 0, message = "{\r\n" + "    \"rc\": 0,\r\n" + "    \"msg\": \"OK\",\r\n"
			+ "    \"items\": [\r\n" + "        {\r\n" + "            \"addTime\": \"2020-07-15 14:43:44\",\r\n"
			+ "            \"chargingItemId\": \"14\",\r\n" + "            \"chargingItemName\": \"纯种犬鉴定服务费\",\r\n"
			+ "            \"price\": \"300.00\",\r\n" + "            \"num\": \"1\",\r\n"
			+ "            \"totalPrice\": \"300.00\",\r\n"
			+ "            \"id\": \"6b7e3bdad8e34da8ab52bc2bb02c0bf9\",\r\n"
			+ "            \"businessTable\": \"dog_appraisal\",\r\n"
			+ "            \"businessIds\": \"592fc5fb46214f6fbed955d7c21834fc\"\r\n" + "        },\r\n"
			+ "        {\r\n" + "            \"addTime\": \"2020-07-15 14:43:44\",\r\n"
			+ "            \"chargingItemId\": \"000191001\",\r\n" + "            \"chargingItemName\": \"视频鉴定费用\",\r\n"
			+ "            \"price\": \"288.00\",\r\n" + "            \"num\": \"1\",\r\n"
			+ "            \"totalPrice\": \"288.00\",\r\n"
			+ "            \"id\": \"f3406b92e4f740e78e11fb9f8e44de16\",\r\n"
			+ "            \"businessTable\": \"dog_video_appraisal\",\r\n"
			+ "            \"businessIds\": \"592fc5fb46214f6fbed955d7c21834fc\"\r\n" + "        }\r\n" + "    ]\r\n"
			+ "}") })
	@RequestMapping(value = "/cart/getCartByIds", method = RequestMethod.GET)
	@ResponseBody
	public void getCartByIds(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String cartIds = request.getParameter("cartIds");
		if (StringUtils.isBlank(cartIds)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "获取参数错误，请重试");
		}
		String[] ids = cartIds.split(",");
		List<PaymentCart> carts = null;
		carts = paymentCartService.getCooperatorCart(false);
		
		List<PaymentCart> cartList = new ArrayList<>();
		for (PaymentCart model : carts) {
			for (String id : ids) {
				if (model.getId().equals(id)) {
					cartList.add(model);
				}
			}
		}
		
		JSONArray array = new JSONArray();
		for (int i = 0; i < cartList.size(); i++) {
			PaymentCart cart = cartList.get(i);
			JSONObject object = new JSONObject();
			object.put("addTime", DateUtils.formatDate(cart.getAddTime(), "yyyy-MM-dd HH:mm:ss"));
			object.put("chargingItemId", cart.getChargingItemId());
			object.put("chargingItemName", cart.getChargingItemName());
			object.put("price", cart.getPrice());
			object.put("num", cart.getNum());
			object.put("totalPrice", cart.getTotalPrice());
			object.put("id", cart.getId());
			object.put("businessTable", cart.getBusinessTable());
			object.put("businessIds", cart.getBusinessIds());
			array.add(object);
		}
		RESTResponse result = new RESTResponse("items", array);
		ServletUtils.writeResponse(response, result);
	}
	
	
	
	
	@ApiOperation(value = "支付", tags = { "club支付" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value="/pay" , method = RequestMethod.GET)
	@ResponseBody
	public void pay(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String orderId = request.getParameter("orderId");
		//判断用户是否是
		
		//判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.get(orderId);
		//如果订单已删除。报错提示
		if("1".equals(order.getDelFlag())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该订单已删除，请勿支付");
		}
		if(order != null && order.getPaymentState().equals("1")){
			restOrderService.balPayClub(order);//余额支付订单
		}else{
			//判断是否是商城订单
			ShopOrder sOrder = shopOrderService.get(orderId);
			if(sOrder != null && sOrder.getPaymentState().equals("1")){
				shopOrderService.clientBalPay(sOrder);//商城余额付款
			}else{
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"订单验证失败");
			}
		}
		
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}
	
	@SuppressWarnings("unchecked")
	@RequestMapping(value = "/coupons", method = RequestMethod.POST)
	@ResponseBody
	public void coupons(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		JSONArray carts = object.getJSONArray("carts");// 购物车记录的ID
		List<String> ids = Arrays.asList(carts.toArray());
		// 根据购物车ID得到可用券列表
		RESTResponse result = new RESTResponse("data",
				objectMapper.writeValueAsString(paymentCartService.getClubCoupons(ids)));
		ServletUtils.writeResponse(response, result);
	}
}
