package com.cku.oa.show.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.service.DogTypeShowService;
import com.cku.oa.show.entity.ShowResultsHk;
import com.cku.oa.show.service.ShowResultsHkService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 香港赛事成绩表Controller
 * @author xx
 * @version 2024-11-14
 */
@Controller
@RequestMapping(value = "${adminPath}/results/showResultsHk")
public class ShowResultsHkController extends BaseController {

	@Autowired
	private ShowResultsHkService showResultsHkService;

	@Autowired
	private DogTypeShowService dogTypeShowService;
	
	@ModelAttribute
	public ShowResultsHk get(@RequestParam(required=false) String id) {
		ShowResultsHk entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showResultsHkService.get(id);
		}
		if (entity == null){
			entity = new ShowResultsHk();
		}
		return entity;
	}
	
	@RequiresPermissions("results:showResultsHk:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowResultsHk showResultsHk, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowResultsHk> page = showResultsHkService.findPage(new Page<ShowResultsHk>(request, response), showResultsHk); 
		model.addAttribute("page", page);

		model.addAttribute("dogBreedList", dogTypeShowService.findAllList());
		return "oa/show/results/showResultsHkList";
	}

	@RequiresPermissions("results:showResultsHk:view")
	@RequestMapping(value = "form")
	public String form(ShowResultsHk showResultsHk, Model model) {
		model.addAttribute("showResultsHk", showResultsHk);

		model.addAttribute("dogBreedList", dogTypeShowService.findAllList());
		return "oa/show/results/showResultsHkForm";
	}

	@RequiresPermissions("results:showResultsHk:edit")
	@RequestMapping(value = "save")
	public String save(ShowResultsHk showResultsHk, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showResultsHk)){
			return form(showResultsHk, model);
		}
		showResultsHkService.save(showResultsHk);
		addMessage(redirectAttributes, "保存香港赛事成绩表成功");
		return "redirect:"+Global.getAdminPath()+"/results/showResultsHk/?repage";
	}
	
	@RequiresPermissions("results:showResultsHk:edit")
	@RequestMapping(value = "delete")
	public String delete(ShowResultsHk showResultsHk, RedirectAttributes redirectAttributes) {
		showResultsHkService.delete(showResultsHk);
		addMessage(redirectAttributes, "删除香港赛事成绩表成功");
		return "redirect:"+Global.getAdminPath()+"/results/showResultsHk/?repage";
	}

	/**
	 * 导入犬展成绩数据
	 * @param file
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("results:showResultsHk:edit")
    @RequestMapping(value = "import", method=RequestMethod.POST)
    public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			int count = showResultsHkService.importShowResults(file);
			addMessage(redirectAttributes,"导入犬展成绩成功，共导入"+count+"条记录。");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入犬展成绩失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/results/showResultsHk/?repage";
    }
	
	@RequiresPermissions("results:showResultsHk:edit")
	@RequestMapping(value = {"ranking"})
	public String ranking(ShowResultsHk showResultsHk, HttpServletRequest request, HttpServletResponse response, Model model) {
		List<ShowResultsHk> list = showResultsHkService.findAllYear( showResultsHk.getYear()); 
		model.addAttribute("list", list);
		return "oa/show/results/showResultsHkRankingList";
	}
	
	
	@RequiresPermissions("results:showResultsHk:edit")
	@RequestMapping(value = {"rankingByYear"})
	@ResponseBody
	public String rankingByYear(ShowResultsHk showResultsHk, HttpServletRequest request, HttpServletResponse response, Model model) {
		try {
		showResultsHkService.rankingByYear( showResultsHk.getYear()); 
		} catch (Exception e) {
			return "{\"rc\":1,\"msg\":\""+e.getMessage()+"\"}";
		}
			
		return "{\"rc\":0}";
	}

}