package com.cku.oa.show.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.oa.show.entity.ShowAdvisor;
import com.cku.oa.show.service.ShowAdvisorService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 赛事顾问Controller
 * @author yuanshuai
 * @version 2025-07-02
 */
@Controller
@RequestMapping(value = "${adminPath}/show/showAdvisor")
public class ShowAdvisorController extends BaseController {

	@Autowired
	private ShowAdvisorService showAdvisorService;
	
	@ModelAttribute
	public ShowAdvisor get(@RequestParam(required=false) String id) {
		ShowAdvisor entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showAdvisorService.get(id);
		}
		if (entity == null){
			entity = new ShowAdvisor();
		}
		return entity;
	}
	
	@RequiresPermissions("show:showAdvisor:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowAdvisor showAdvisor, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowAdvisor> page = showAdvisorService.findPage(new Page<ShowAdvisor>(request, response), showAdvisor); 
		model.addAttribute("page", page);
		return "oa/show/advisor/showAdvisorList";
	}

	@RequiresPermissions("show:showAdvisor:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(ShowAdvisor showAdvisor, Model model) {
		model.addAttribute("showAdvisor", showAdvisor);
		model.addAttribute("isView", 1);
		return "oa/show/advisor/showAdvisorForm";
	}
	@RequiresPermissions("show:showAdvisor:edit")
	@RequestMapping(value = "editForm")
	public String editForm(ShowAdvisor showAdvisor, Model model) {
		model.addAttribute("showAdvisor", showAdvisor);
		model.addAttribute("isView", 0);
		return "oa/show/advisor/showAdvisorForm";
	}


	@PostMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(ShowAdvisor showAdvisor) {
		try {
			boolean hasPermission = false;
			if(StringUtils.isEmpty(showAdvisor.getId())){
				hasPermission = SecurityUtils.getSubject().isPermitted("show:showAdvisor:add");
			}else{
				hasPermission = SecurityUtils.getSubject().isPermitted("show:showAdvisor:edit");
			}
			if(!hasPermission){
				throw new AuthorizationException("用户权限不足");
			}
			restBeanValidator(showAdvisor);
			showAdvisorService.save(showAdvisor);
		} catch (Exception ex) {
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return ResultDto.success(showAdvisor.getId());
	}

	@RequiresPermissions("show:showAdvisor:del")
	@RequestMapping(value = "delete")
	public String delete(ShowAdvisor showAdvisor, RedirectAttributes redirectAttributes) {
		showAdvisorService.delete(showAdvisor);
		addMessage(redirectAttributes, "删除赛事顾问成功");
		return "redirect:"+Global.getAdminPath()+"/show/showAdvisor/?repage";
	}

}