package com.cku.oa.order.service;

import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.oa.order.vo.request.OrderBusinessRequest;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;

import java.util.List;

/**
 * 业务服务
 *
 * @author yuanshuai
 * @date 2023/6/18 15:04
 */
public interface IOrderBusinessService<T extends OrderBusinessRequest> {

    /**
     * 下单前数据校验并获取商品列表
     *
     * @param orderRequest    下单相关参数
     * @param businessRequest 业务具体参数
     * @param member          会员
     * @author yuanshuai
     * @date 2023/6/18 16:26
     */
    void businessValidate(OrderApplyRequest orderRequest, T businessRequest, Member member);

    /**
     * 下单前数据校验并获取商品列表
     *
     * @param orderRequest    下单相关参数
     * @param businessRequest 业务具体参数
     * @param member          会员
     * @return SKU列表，包含skuID、名称、价格、数量信息
     * @author yuanshuai
     * @date 2023/6/18 16:26
     */
    List<OrderSkuVo> preOrder(OrderApplyRequest orderRequest, T businessRequest, Member member);

}
