package com.cku.oa.finance.web.statistics;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.finance.dao.statistics.OrderDetailsDao;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;


/**
 * 订单详情
 * @author xuzhenxing
 *
 */

@Controller
@RequestMapping(value = "${adminPath}/finance/statistics/")
public class OrderDetailsController {
	
	@Autowired
	private OrderDetailsDao OrderDetailsDao;
	
	@RequestMapping(value = "orderDetails")
	public String orderDetails(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
		String orderCode = request.getParameter("orderCode");
		String orderID = request.getParameter("orderID");
		//订单详情的订单编号及会员号显示
		Map contentHead = new HashMap<String,Object>();
		contentHead = OrderDetailsDao.orderHead(orderID, orderCode);
		
		List<Map> orderBody = OrderDetailsDao.orderBody(contentHead.get("orderCode").toString());
		List<String> contentBody = new ArrayList();
		if(orderBody.size()>0){
			for(int i=0; i< orderBody.size();i++)
			{
				String chargingItemName = orderBody.get(i).get("chargingItemName").toString();
				String num = orderBody.get(i).get("num").toString();
				String price = orderBody.get(i).get("price").toString();
				String totalPrice = orderBody.get(i).get("totalPrice").toString();
				String addTime = orderBody.get(i).get("addTime").toString();
				String paymentItemID = orderBody.get(i).get("chargingItemID").toString();				
				contentBody.add(orderHead(contentHead.get("orderCode").toString(), paymentItemID,chargingItemName, num, price, totalPrice, addTime));
			}
		}
		
		model.addAttribute("contentBody",contentBody);
		model.addAttribute("contentHead",contentHead);
		return "oa/finance/statistics/orderDetails";	
	}
	
	public String orderHead(String orderCode, String paymentItemID,String chargingItemName, String num, String price, String totalPrice, String addTime){
		StringBuilder content = new StringBuilder();
		content.append("<table class=\"table table-striped table-bordered table-condensed\">");
		content.append("	<tr>");
		content.append("		<th style=\"width:240px;\">商品名称</th>");
		content.append("		<th style=\"width:100px;\">数量</th>");
		content.append("		<th style=\"width:100px;\">单价</th>");
		content.append("		<th style=\"width:100px;\">总价</th>");
		content.append("		<th>时间</th>");
		content.append("	</tr>");
		content.append("	<tr>");
		content.append("		<td>");
		content.append(chargingItemName);
		content.append("		</td>");
		content.append("		<td>");
		content.append(num);
		content.append("		</td>");
		content.append("		<td>");
		content.append(price);
		content.append("		</td>");
		content.append("		<td>");
		content.append(totalPrice);
		content.append("		</td>");
		content.append("		<td>");
		content.append(addTime);
		content.append("		</td>");
		content.append("	</tr>");
		content.append("	</table>");
		content.append("	<div style=\"margin-left:50px;\">");
		content.append(generateTable(orderCode,paymentItemID));
		content.append("	</div>");
		return content.toString();
	}
	
	public String generateTable(String orderCode, String paymentItemID)
	{
		StringBuilder content = new StringBuilder();
		switch(paymentItemID){
		//犬舍更名
			case "8":
				List<Map> kennelRename = OrderDetailsDao.kennelRename(orderCode);
				if(kennelRename.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			会员号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			原犬舍中文名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			原犬舍英文名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			新犬舍中文名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			新犬舍英文名");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");
					for(int i = 0; i < kennelRename.size(); i++){					
					content.append("	<tr>");
					content.append("		<td>"+kennelRename.get(i).get("memberCode")+"</td>");
					content.append("		<td>"+kennelRename.get(i).get("originalNameCN")+"</td>");	
					content.append("		<td>"+kennelRename.get(i).get("originalNameEN")+"</td>");	
					content.append("		<td>"+kennelRename.get(i).get("newNameCN")+"</td>");	
					content.append("		<td>"+kennelRename.get(i).get("newNameEN")+"</td>");
					content.append("		<td>"+DictUtils.getDictLabels(kennelRename.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
					content.append("		<td>"+DictUtils.getDictLabels(kennelRename.get(i).get("reviewState").toString(), "review_state", "")+"</td>");
					content.append("	</tr>");					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			//犬舍主理人变更
			case "9":
				List<Map> kennelOwnerChange = OrderDetailsDao.kennelOwnerChange(orderCode);
				
				if(kennelOwnerChange.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			犬舍中文名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			原主理人");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			新主理人");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < kennelOwnerChange.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+kennelOwnerChange.get(i).get("kennelName")+"</td>");
						content.append("		<td>"+kennelOwnerChange.get(i).get("oldMemberCode")+"</td>");	
						content.append("		<td>"+kennelOwnerChange.get(i).get("newMemberCode")+"</td>");	
						content.append("		<td>"+DictUtils.getDictLabels(kennelOwnerChange.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(kennelOwnerChange.get(i).get("reviewState").toString(), "review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			//配种证明
			case "12":
			case "99":
			case "132":
				List<Map> dogNew = OrderDetailsDao.dogNew(orderCode);
				if(dogNew.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			配犬编号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			公犬证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			母犬证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			母犬主人");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			配种日期");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogNew.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogNew.get(i).get("breedCertifiedCode")+"</td>");
						content.append("		<td>"+dogNew.get(i).get("malePedigreeCertified")+"</td>");	
						content.append("		<td>"+dogNew.get(i).get("femalePedigreeCertified")+"</td>");	
						content.append("		<td>"+dogNew.get(i).get("fdogOwner")+"</td>");
						content.append("		<td>"+dogNew.get(i).get("breedDate")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogNew.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogNew.get(i).get("reviewState").toString(), "review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			//国外证书号
			case "16":
				List<Map> dogOverseasPedigreeChange = OrderDetailsDao.dogOverseasPedigreeChange(orderCode);
				if(dogOverseasPedigreeChange.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			国外证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			犬种");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			犬名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			性别");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			出生日期");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogOverseasPedigreeChange.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogOverseasPedigreeChange.get(i).get("overseaPedigreeCertified")+"</td>");
						content.append("		<td>"+dogOverseasPedigreeChange.get(i).get("dogBreed")+"</td>");	
						content.append("		<td>"+dogOverseasPedigreeChange.get(i).get("dogName")+"</td>");	
						content.append("		<td>"+DictUtils.getDictLabels(dogOverseasPedigreeChange.get(i).get("dogGender").toString(), "dog_gender", "")+"</td>");
						content.append("		<td>"+dogOverseasPedigreeChange.get(i).get("dogBirthday")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogOverseasPedigreeChange.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogOverseasPedigreeChange.get(i).get("reviewState").toString(), "review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			//证书出口	
			case "17":
			case "135":
				List<Map> dogPedigreeExport = OrderDetailsDao.dogPedigreeExport(orderCode);
				if(dogPedigreeExport.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			血统证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			出口国家");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			新犬主人");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogPedigreeExport.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogPedigreeExport.get(i).get("pedigreeCertified")+"</td>");
						content.append("		<td>"+dogPedigreeExport.get(i).get("exportDestination")+"</td>");	
						content.append("		<td>"+dogPedigreeExport.get(i).get("exporter")+"</td>");	
						content.append("		<td>"+DictUtils.getDictLabels(dogPedigreeExport.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogPedigreeExport.get(i).get("reviewState").toString(), "review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			//鉴定犬只
			case "20":
			case "15":
			case "130":
			case "125":
			case "203":
				List<Map> dogAppraisal = OrderDetailsDao.dogAppraisal(orderCode);
				if(dogAppraisal.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			鉴定方式");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			犬种");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			犬名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			性别");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			出生日期");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogAppraisal.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+DictUtils.getDictLabels(dogAppraisal.get(i).get("identifyType").toString(), "dog_appraisal_type", "")+"</td>");
						content.append("		<td>"+dogAppraisal.get(i).get("breedName")+"</td>");
						content.append("		<td>"+dogAppraisal.get(i).get("dogName")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogAppraisal.get(i).get("dogGender").toString(), "dog_gender", "")+"</td>");
						content.append("		<td>"+dogAppraisal.get(i).get("dogBirthday")+"</td>");	
						content.append("		<td>"+DictUtils.getDictLabels(dogAppraisal.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogAppraisal.get(i).get("reviewState").toString(), "dog_appraisal_review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			//DNA存档
			case "22":
			case "127":
			case "183":
				List<Map> dogDNAArchive = OrderDetailsDao.dogDNAArchive(orderCode);
				if(dogDNAArchive.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			血统证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			DNA档案号");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogDNAArchive.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogDNAArchive.get(i).get("pedigreeCertified")+"</td>");
						content.append("		<td>"+dogDNAArchive.get(i).get("DNACode")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogDNAArchive.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogDNAArchive.get(i).get("reviewState").toString(), "review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
				//犬主变更
			case "24":
			case "136":
				List<Map> dogOwnerChange = OrderDetailsDao.dogOwnerChange(orderCode);
				if(dogOwnerChange.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			血统证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			犬主人");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			新犬主人");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogOwnerChange.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogOwnerChange.get(i).get("pedigreeCertified")+"</td>");
						content.append("		<td>"+dogOwnerChange.get(i).get("oldOwner")+"</td>");
						content.append("		<td>"+dogOwnerChange.get(i).get("newOwner")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogOwnerChange.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogOwnerChange.get(i).get("reviewState").toString(), "review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			case "25":
			case "137":
				List<Map> dogPedigreeRedo = OrderDetailsDao.dogPedigreeRedo(orderCode);
				if(dogPedigreeRedo.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			原证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			新证书号");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogPedigreeRedo.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogPedigreeRedo.get(i).get("oldPedigree")+"</td>");
						content.append("		<td>"+dogPedigreeRedo.get(i).get("newPedigree")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogPedigreeRedo.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogPedigreeRedo.get(i).get("reviewState").toString(), "dog_pedigree_certified_redo_review_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
				
				//血统证书申请
			case "13":
			case "76":
			case "134":
				List<Map> dogChip = OrderDetailsDao.dogChip(orderCode);
				if(dogChip.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th style=\"width:200px\">");
					content.append("			出生纸编号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			提交时间");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogChip.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogChip.get(i).get("birthCode")+"</td>");
						content.append("		<td>"+dogChip.get(i).get("CreateDate")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogChip.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogChip.get(i).get("reviewState").toString(), "dog_birth_certificate_review_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogChip.get(i).get("proccessState").toString(), "proccess_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
					List<Map> dogChipChange = OrderDetailsDao.dogChipChange(orderCode);
					if(dogChipChange.size()>0)
					{
						content.append("<br/>");
						content.append("<table class=\"table table-striped table-bordered table-condensed\">");
						content.append("	<tr>");
						content.append("		<th style=\"width:200px\">");
						content.append("			血统证书号");
						content.append("		</th>");
						content.append("		<th>");
						content.append("			原芯片号");
						content.append("		</th>");
						content.append("		<th>");
						content.append("			新芯片号");
						content.append("		</th>");
						content.append("		<th>");
						content.append("			提交时间");
						content.append("		</th>");
						content.append("		<th colspan=\"3\">");
						content.append("			状态");
						content.append("		</th>");
						content.append("	</tr>");	
						for(int i = 0; i < dogChipChange.size(); i++){
						
					
							content.append("	<tr>");
							content.append("		<td>"+dogChipChange.get(i).get("pedigreeCertifiedCode")+"</td>");
							content.append("		<td>"+dogChipChange.get(i).get("oldChipCode")+"</td>");
							content.append("		<td>"+dogChipChange.get(i).get("newChipCode")+"</td>");
							content.append("		<td>"+dogChipChange.get(i).get("createDate")+"</td>");
							content.append("		<td>"+DictUtils.getDictLabels(dogChipChange.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
							content.append("		<td>"+DictUtils.getDictLabels(dogChipChange.get(i).get("reviewState").toString(), "dog_birth_certificate_review_state", "")+"</td>");
							content.append("		<td>"+DictUtils.getDictLabels(dogChipChange.get(i).get("proccessState").toString(), "proccess_state", "")+"</td>");
							content.append("	</tr>");
						
						}
						content.append("</table>");
					}
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
			//赛事报名	
			case "45"://犬只参赛费（北京自办）
			case "219"://犬只参赛费（重庆自办）
			case "220"://犬只参赛费（重庆合办）
			case "221"://犬只参赛费（长春自办）
			case "222"://犬只参赛费（长春合办）
			case "140"://犬只参赛费（北京合办）
			case "141"://犬只参赛费（杭州自办）
			case "142"://犬只参赛费（杭州合办）
				List<Map> showApply = OrderDetailsDao.showApply(orderCode);
				if(showApply.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			血统证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			赛事名称");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			年龄组别");
					content.append("		</th>");
					content.append("		<th");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < showApply.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+showApply.get(i).get("pedigreeCertified")+"</td>");
						content.append("		<td>");
						String showCode[] = showApply.get(i).get("showCode").toString().split(",");
						for (int j = 0; j < showCode.length; j++) {
							content.append(showCode[j]+"<br/>");
						}
						content.append("</td>");
						content.append("		<td>"+DictUtils.getDictLabels(showApply.get(i).get("ageGroup").toString(), "show_age_group", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(showApply.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;				
//			case "122":
//			case "164":
			case "58":			
			case "133":
				List<Map> dogNewBornAndBirth = OrderDetailsDao.dogNewBornAndBirth(orderCode);
				if(dogNewBornAndBirth.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			出生证明登记编号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			繁殖人");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			英文姓名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			种类");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < dogNewBornAndBirth.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+dogNewBornAndBirth.get(i).get("birthCode")+"</td>");
						content.append("		<td>"+dogNewBornAndBirth.get(i).get("breeder")+"</td>");
						content.append("		<td>"+dogNewBornAndBirth.get(i).get("dogENName")+"</td>");
						content.append("		<td>"+dogNewBornAndBirth.get(i).get("breedName")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogNewBornAndBirth.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(dogNewBornAndBirth.get(i).get("proccessState").toString(), "proccess_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
				
			case "49":
			case "50":
			case "191":
			case "192":
			case "193":
			case "194":
			case "218":
				List<Map> showChampion = OrderDetailsDao.dogNewBornAndBirth(orderCode);
				if(showChampion.size()>0)
				{
					content.append("<table class=\"table table-striped table-bordered table-condensed\">");
					content.append("	<tr>");
					content.append("		<th>");
					content.append("			登录类型");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			血统证书号");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			犬只英文姓名");
					content.append("		</th>");
					content.append("		<th>");
					content.append("			芯片号");
					content.append("		</th>");
					content.append("		<th colspan=\"2\">");
					content.append("			状态");
					content.append("		</th>");
					content.append("	</tr>");	
					for(int i = 0; i < showChampion.size(); i++){
					
				
						content.append("	<tr>");
						content.append("		<td>"+DictUtils.getDictLabels(showChampion.get(i).get("loginType").toString(), "champion_login_type", "")+"</td>");
						content.append("		<td>"+showChampion.get(i).get("pedigreeCertified")+"</td>");
						content.append("		<td>"+showChampion.get(i).get("dogENName")+"</td>");
						content.append("		<td>"+showChampion.get(i).get("IDFlag")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(showChampion.get(i).get("paymentState").toString(), "user_payment_state", "")+"</td>");
						content.append("		<td>"+DictUtils.getDictLabels(showChampion.get(i).get("proccessState").toString(), "proccess_state", "")+"</td>");
						content.append("	</tr>");
					
					}
					content.append("</table>");
				}else{
					content.append("<p>没有详细记录内容</p>");
				}
				break;
				
				default:
					if(orderCode.length()==14){
						List<Map> others = OrderDetailsDao.others(orderCode, paymentItemID);
						if(others.size() > 0)
						{
							for(int i = 0; i < others.size(); i++)
							if(others.get(0).get("processState")!= null && others.get(0).get("processState").toString().equals("1")){
								content.append("<p>订单已处理</p>");	
							}else{
								content.append("<p>该业务订单没有详情</p>");
							}
							
						}else{
							content.append("<p>该业务订单没有详情</p>");
						}
						
					}else{
						content.append("<p>该业务订单没有详情</p>");
					}
		}
		return content.toString();
	}
}
