package com.cku.oa.finance.entity;

import com.cku.util.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import com.thinkgem.jeesite.modules.sys.entity.User;
import org.hibernate.validator.constraints.Length;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/28
 * Time: 10:23
 */
public class MemberBalance extends DataEntity<MemberBalance> {

    private static final long serialVersionUID = 1L;
    @ExcelField(title="会员号", align=2, sort=1)
    private String memberCode;		// 会员号
    private String businessId;		// 业务表id
    private String chargingItemId;		// 付款条目，参考payment_item表。如果payment_item为空，代表账号充值
    private Integer chargingItemNum; //付款条目数量
    private String paymentAmount;		// 实付金额
    private String price;		// 付款服务的价格
    private String paymentWay;		// 参见数据字典表：代表的是支付宝充值，赛场收费，建行网银充值等
    private String runningNumber;		// 流水号
    private String paymentState;		// 付款状态
    private String outTradeNo;		// 支付宝返回的参数out_trade_no
    private Date paymentTime;    //支付时间
    private String paymentRemarks;		// 付款备注
    private User updateByName;		// update_by_name
    private String alipayS;		// 支付宝的参数

    private String timeType;        //时间类型
    private Date startPaymentTime;  //查询开始时间
    private Date endPaymentTime;    //查询结束时间
    @ExcelField(title="名称", align=2, sort=2)
    private String memberName;  //会员名称
    @ExcelField(title="账户金额", align=2, sort=3)
    private String memberBalance;   //会员余额

    private String totalType;       //统计类型
    private String totalPrice;      //统计钱数
    private String uncompletedIncome;      //未完成业务金额
    private String totalIncome;      //合计


    public String getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(String totalIncome) {
        this.totalIncome = totalIncome;
    }

    public String getUncompletedIncome() {
        return uncompletedIncome;
    }

    public void setUncompletedIncome(String uncompletedIncome) {
        this.uncompletedIncome = uncompletedIncome;
    }

    public MemberBalance() {
        super();
    }
    public MemberBalance(String totalType,String totalPrice){
        this.totalPrice = totalPrice;
        this.totalType = totalType;
    }
    public MemberBalance(String id){
        super(id);
    }

    @Length(min=0, max=60, message="会员号长度必须介于 0 和 60 之间")
    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    @Length(min=0, max=64, message="业务表id长度必须介于 0 和 64 之间")
    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    @Length(min=0, max=64, message="付款条目，参考payment_item表。如果payment_item为空，代表账号充值长度必须介于 0 和 64 之间")
    public String getChargingItemId() {
        return chargingItemId;
    }

    public void setChargingItemId(String chargingItemId) {
        this.chargingItemId = chargingItemId;
    }

    public Integer getChargingItemNum() {
        return chargingItemNum;
    }

    public void setChargingItemNum(Integer chargingItemNum) {
        this.chargingItemNum = chargingItemNum;
    }

    public String getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(String paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @Length(min=0, max=64, message="参见数据字典表：代表的是支付宝充值，赛场收费，建行网银充值等长度必须介于 0 和 64 之间")
    public String getPaymentWay() {
        return paymentWay;
    }

    public void setPaymentWay(String paymentWay) {
        this.paymentWay = paymentWay;
    }

    @Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
    public String getRunningNumber() {
        return runningNumber;
    }

    public void setRunningNumber(String runningNumber) {
        this.runningNumber = runningNumber;
    }

    @Length(min=0, max=20, message="付款状态长度必须介于 0 和 20 之间")
    public String getPaymentState() {
        return paymentState;
    }

    public void setPaymentState(String paymentState) {
        this.paymentState = paymentState;
    }

    @Length(min=0, max=50, message="支付宝返回的参数out_trade_no长度必须介于 0 和 50 之间")
    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getStartPaymentTime() {
        return startPaymentTime;
    }

    public void setStartPaymentTime(Date startPaymentTime) {
        this.startPaymentTime = startPaymentTime;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getEndPaymentTime() {
        return endPaymentTime;
    }

    public void setEndPaymentTime(Date endPaymentTime) {
        this.endPaymentTime = endPaymentTime;
    }

    public String getTimeType() {
        return timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
        Date nowTime = new Date();
        if(timeType==null || "".equals(timeType)){
            this.startPaymentTime = null;
            this.endPaymentTime = null;
        }else if("0".equals(timeType)){
            this.endPaymentTime = nowTime;
            this.startPaymentTime = DateUtils.lastMonth(1);
        }else if("1".equals(timeType)){
            this.endPaymentTime = DateUtils.lastMonth(1);
            this.startPaymentTime =DateUtils.lastMonth(3);
        }else if("2".equals(timeType)){
            this.endPaymentTime = DateUtils.lastMonth(3);
            this.startPaymentTime =DateUtils.lastMonth(6);
        }else if("3".equals(timeType)){
            this.endPaymentTime = DateUtils.lastMonth(6);
            this.startPaymentTime =DateUtils.lastMonth(12);
        }else{
            this.endPaymentTime = DateUtils.lastMonth(12);
            this.startPaymentTime = null;
        }

    }



    @Length(min=0, max=255, message="付款备注长度必须介于 0 和 255 之间")
    public String getPaymentRemarks() {
        return paymentRemarks;
    }

    public void setPaymentRemarks(String paymentRemarks) {
        this.paymentRemarks = paymentRemarks;
    }

    public User getUpdateByName() {
        return updateByName;
    }

    public void setUpdateByName(User updateByName) {
        this.updateByName = updateByName;
    }

    @Length(min=0, max=100, message="支付宝的参数长度必须介于 0 和 100 之间")
    public String getAlipayS() {
        return alipayS;
    }

    public void setAlipayS(String alipayS) {
        this.alipayS = alipayS;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getMemberBalance() {
        return memberBalance;
    }

    public void setMemberBalance(String memberBalance) {
        this.memberBalance = memberBalance;
    }

    public String getTotalType() {
        return totalType;
    }

    public void setTotalType(String totalType) {
        this.totalType = totalType;
    }

    public String getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(String totalPrice) {
         this.totalPrice = totalPrice;
    }
}
