package com.cku.oa.dog.web;

import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.entity.DogSemenChange;
import com.cku.oa.dog.service.DogSemenChangeService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 犬只精子变更Controller
 *
 * @author lgl
 * @version 2017-08-29
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogSemenChange")
public class DogSemenChangeController extends BaseController {

    @Autowired
    private DogSemenChangeService dogSemenChangeService;

    private final static String REPAGE = "redirect:" + Global.getAdminPath() + "/dog/dogSemenChange/?repage";

    private final static String AUTHORITY_PRDFIX = "dog:dogSemenChange:";

    @ModelAttribute
    public DogSemenChange get(@RequestParam(required = false) String id) {
        DogSemenChange entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogSemenChangeService.get(id);
        }
        if (entity == null) {
            entity = new DogSemenChange();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(DogSemenChange dogSemenChange, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogSemenChange> page = dogSemenChangeService.findPage(new Page<DogSemenChange>(request, response), dogSemenChange);
        model.addAttribute("page", page);
        return "oa/dog/dogsemenchange/dogSemenChangeList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(DogSemenChange dogSemenChange, Model model) {
        model.addAttribute("dogSemenChange", dogSemenChange);
        List<DogSemen> dogSemenList = dogSemenChangeService.getDogSemenList(dogSemenChange);
        model.addAttribute("dogSemenList", dogSemenList);
        model.addAttribute("dogSemenListCount", dogSemenList.size());
        return "oa/dog/dogsemenchange/dogSemenChangeForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "audit")
    @RequestMapping(value = "auditForm")
    public String auditForm(DogSemenChange dogSemenChange, Model model) {
        model.addAttribute("dogSemenChange", dogSemenChange);
        List<DogSemen> dogSemenList = dogSemenChangeService.getDogSemenList(dogSemenChange);
        model.addAttribute("dogSemenList", dogSemenList);
        model.addAttribute("dogSemenListCount", dogSemenList.size());
        return "oa/dog/dogsemenchange/dogSemenChangeAuditForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "save")
    public String save(DogSemenChange dogSemenChange, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogSemenChange)) {
            return form(dogSemenChange, model);
        }
        dogSemenChangeService.save(dogSemenChange);
        addMessage(redirectAttributes, "保存犬只精子变更成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "delete")
    public String delete(DogSemenChange dogSemenChange, RedirectAttributes redirectAttributes) {
        dogSemenChangeService.delete(dogSemenChange);
        addMessage(redirectAttributes, "删除犬只精子变更成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "audit")
    @RequestMapping(value = "audit")
    public String audit(DogSemenChange dogSemenChange, RedirectAttributes redirectAttributes) {
        addMessage(redirectAttributes, "处理证书换发成功");
        try {
            dogSemenChangeService.ckuAudit(dogSemenChange);
        } catch (Exception e) {
            addMessage(redirectAttributes, "处理证书换发失败:" + e.getMessage());
        }
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "resolve")
    @RequestMapping(value = "resolve")
    public String resolve(DogSemenChange dogSemenChange, RedirectAttributes redirectAttributes) {
        addMessage(redirectAttributes, "处理证书换发成功");
        try {
            dogSemenChangeService.resolve(dogSemenChange);
        } catch (Exception e) {
            addMessage(redirectAttributes, "处理证书换发失败:" + e.getMessage());
        }
        return REPAGE;
    }

}