package com.cku.oa.dog.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.cku.logUtil.JSONObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDnaParentsCompareDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.enums.DnaParentsCompareApplySourceEnum;
import com.cku.oa.dog.enums.GoldCertifiedStateEnum;
import com.cku.oa.dog.vo.DogDnaParentsCompareVO;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.partner.club.service.ClubDogChipDeleteService;
import com.cku.restful.v1.dog.vo.request.GoldCertifiedPageRequest;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedPageResp;
import com.cku.restful.v1.finance.service.OADeleteService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * DNA双亲比对Service
 *
 * @author lgl
 * @version 2016-11-24
 */
@Service
@Transactional(readOnly = true)
public class DogDnaParentsCompareService extends CrudService<DogDnaParentsCompareDao, DogDnaParentsCompare> {

	@Autowired
	private OADeleteService oADeleteService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private ClubDogChipDeleteService clubDogChipDeleteService;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private UserService userService;

	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;

	public DogDnaParentsCompare get(String id) {
		return super.get(id);
	}

	public List<DogDnaParentsCompare> findList(DogDnaParentsCompare dogDnaParentsCompare) {
		if (StringUtils.isBlank(dogDnaParentsCompare.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogDnaParentsCompare.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogDnaParentsCompare.getSqlMap().put("dogBreedMap", " ='" + dogDnaParentsCompare.getDogBreed() + "'");
		}
		return super.findList(dogDnaParentsCompare);
	}

	public Page<DogDnaParentsCompare> findPage(Page<DogDnaParentsCompare> page,
			DogDnaParentsCompare dogDnaParentsCompare) {
		if (StringUtils.isBlank(dogDnaParentsCompare.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogDnaParentsCompare.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogDnaParentsCompare.getSqlMap().put("dogBreedMap", " ='" + dogDnaParentsCompare.getDogBreed() + "'");
		}
		return super.findPage(page, dogDnaParentsCompare);
	}

	@Transactional(readOnly = false)
	public void save(DogDnaParentsCompare dogDnaParentsCompare) {
		super.save(dogDnaParentsCompare);
	}

	@Transactional(readOnly = false)
	public void delete(DogDnaParentsCompare dogDnaParentsCompare) {
		// 已缴费的订单不允许删除
		if ("2".equals(dogDnaParentsCompare.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已缴费，不允许删除");
		}
		// OA删除订单
		oADeleteService.deleteUnpay(dogDnaParentsCompare.getPaymentState(), "dog_dna_parents_compare",
				dogDnaParentsCompare.getId(), dogDnaParentsCompare.getRunningNumber());
		// 如果是oa报名的话，没有订单，故没走上面的删除，所以需要再次删除
		super.delete(dogDnaParentsCompare);
		// 地方俱乐部未交费订单删除
		clubDogChipDeleteService.deleteUnpayDogChipBusiness(dogDnaParentsCompare.getBirthCode());
	}

	/**
	 * @description: DNA双亲比对审核
	 * @author: laiguanglong
	 * @date: 2016/11/28 15:12
	 */
	@Transactional(readOnly = false)
	public void audit(DogDnaParentsCompare audit) throws ZAException {
		try {
			DogDnaParentsCompare dogDnaParentsCompare = get(audit.getId());
			Dog dog = null;
			if (!StringUtils.isBlank(dogDnaParentsCompare.getBirthCode())) {
				dog = dogService.getByBirthCertificateLevelCode(dogDnaParentsCompare.getBirthCode());
			}
			String contextReviewState = dogDnaParentsCompare.getReviewState();
			// 未通过可继续审核
			if (!"1".equals(contextReviewState)) {
				contextReviewState = "0";
			}
			SysContext sysContext = new SysContext(dogDnaParentsCompare.getPaymentState(), contextReviewState, "0");
			if ("1".equals(audit.getReviewState())) {
				// 通过
				// 校验父母及自身DNA存档是否完成
				if (validateThirdDnaIsFinish(dogDnaParentsCompare)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只及其父母犬需均已有DNA结果数据");
				}
				if (StringUtils.isBlank(dogDnaParentsCompare.getPedigreeCertified()) && Objects.isNull(dog)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请先生成犬只证书号再完成亲子比对审核操作");
				}
				dogDnaParentsCompare.setReviewState("1");
				dogDnaParentsCompare.setGoldCertifiedState(GoldCertifiedStateEnum.NORMAL.code());
				// 更新犬只信息
				dogService.updateGoldCertifiedInfo(dogDnaParentsCompare);
				sysContext.confirmSuccess(sysContext, "DNA双亲比对", dogDnaParentsCompare.getPaymentMemberCode(),
						"dog_dna_parents_compare", dogDnaParentsCompare.getId(),
						dogDnaParentsCompare.getRunningNumber(), (str) -> {
						});
				// TODO 财务收入确认时点
				saPaymentDetailTotalService.financeConfirmTime(dogDnaParentsCompare.getId(), "dog_dna_parents_compare");
			} else if ("2".equals(audit.getReviewState())) {
				// 未通过
				// 如果是复检状态改为不通过，则降级处理
				if ("11".equals(dogDnaParentsCompare.getReviewState())) {
					if (StringUtils.isBlank(dogDnaParentsCompare.getPedigreeCertified()) && Objects.isNull(dog)) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请先生成犬只证书号再完成亲子比对审核操作");
					}
					dogDnaParentsCompare.setGoldCertifiedState(GoldCertifiedStateEnum.DOWNGRADE.code());
					// 更新犬只信息
					dogService.updateGoldCertifiedInfo(dogDnaParentsCompare);
				}
				// 更新审核状态
				dogDnaParentsCompare.setReviewState("2");
				sysContext.confirmFail(sysContext, "DNA双亲比对", audit.getReviewRemarks(),
						dogDnaParentsCompare.getPaymentMemberCode(), "dog_dna_parents_compare",
						dogDnaParentsCompare.getId(), dogDnaParentsCompare.getRunningNumber(), (str) -> {
						});

			} else {
				dogDnaParentsCompare.setReviewState(audit.getReviewState());
			}
			dogDnaParentsCompare.setReviewRemarks(audit.getReviewRemarks());
			dogDnaParentsCompare.setReviewTime(new Date());
			super.save(dogDnaParentsCompare);
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * 更新金质证书状态
	 * 
	 * @author yuanshuai
	 * @since 2024/3/11 17:06
	 */
	private void updateGoldCertifiedState(DogDnaParentsCompare dogDnaParentsCompare, Integer code) {

	}

	/**
	 * 根据亲子比对校验自身及父母犬是否已完成DNA存档
	 * 
	 * @author yuanshuai
	 * @date 2023/7/12 16:15
	 */
	private Boolean validateThirdDnaIsFinish(DogDnaParentsCompare dogDnaParentsCompare) {
		DogDnaArchive selfDna = null;
		DogDnaArchive maleDna = null;
		DogDnaArchive femaleDna = null;
		if (!DnaParentsCompareApplySourceEnum.PEDIGREE_CERTIFIED_UPGRADE.code()
				.equals(dogDnaParentsCompare.getApplySource())) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
					.getByBirthCerRegCode(dogDnaParentsCompare.getBirthCode());
			if (Objects.nonNull(dogBirthCertificate)) {
				selfDna = dogDnaArchiveService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
				maleDna = dogDnaArchiveService.getByPediCodeOrChipCode(dogBirthCertificate.getFdogPedigreeCertified());
				femaleDna = dogDnaArchiveService
						.getByPediCodeOrChipCode(dogBirthCertificate.getMdogPedigreeCertified());

			}
		} else {
			Dog dog = dogService.getByPedigreeCertifiedCode(dogDnaParentsCompare.getPedigreeCertified());
			if (Objects.nonNull(dog)) {
				selfDna = dogDnaArchiveService.getByPediCodeOrChipCode(dog.getPedigreeCertifiedCode());
				maleDna = dogDnaArchiveService.getByPediCodeOrChipCode(dog.getFdogPedigreeCertified());
				femaleDna = dogDnaArchiveService.getByPediCodeOrChipCode(dog.getMdogPedigreeCertified());
			}
		}
		if (Objects.nonNull(selfDna) && StringUtils.isNotBlank(selfDna.getDnaCode()) && Objects.nonNull(maleDna)
				&& StringUtils.isNotBlank(maleDna.getDnaCode()) && Objects.nonNull(femaleDna)
				&& StringUtils.isNotBlank(femaleDna.getDnaCode())) {
			return Boolean.FALSE;
		} else {
			return Boolean.TRUE;
		}
	}

	public DogDnaParentsCompare getByBirthCode(String birthCode) {
		return dao.getByBirthCode(birthCode);
	}

	/**
	 * @description: 保存双亲比对申请
	 * @author: laiguanglong
	 * @date: 2016年8月24日 下午4:08:43
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void add(DogDnaParentsCompare add) throws ZAException {
		if (StringUtils.isBlank(add.getPedigreeCertified()) && StringUtils.isBlank(add.getBirthCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入血统证书号或出生纸编号");
		}
		DogDnaParentsCompare dogDnaParentsCompare = new DogDnaParentsCompare();
		Dog dog = null;
		DogBirthCertificate dogBirthCertificate = null;
		if (StringUtils.isNotBlank(add.getPedigreeCertified())) {
			dog = dogService.getByPedigreeCertifiedCode(add.getPedigreeCertified());
			if (dog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号有误");
			}
			// 0根据出生纸编号查重
			if (dao.getByBirthCode(dog.getBirthCertificateLevelCode()) != null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已有DNA双亲比对业务记录");
			}
			dogDnaParentsCompare.setBirthCode(dog.getBirthCertificateLevelCode());
		}
		if (StringUtils.isNotBlank(add.getBirthCode())) {
			dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(add.getBirthCode());
			if (dogBirthCertificate == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生纸编号有误");
			}
			// 0根据出生纸编号查重
			if (dao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode()) != null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已有DNA双亲比对业务记录");
			}
			dogDnaParentsCompare.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		}
		if (dog != null && dogBirthCertificate != null
				&& !dog.getBirthCertificateLevelCode().equals(dogBirthCertificate.getBirthCerRegCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该血统证书号与出生纸编号不匹配，请检查");
		}
		dogDnaParentsCompare.setPaymentMemberCode(add.getPaymentMemberCode());
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(add.getPaymentChargingItemId());
		dogDnaParentsCompare.setPrice(paymentChargingItem.getPrice());
		dogDnaParentsCompare.setReviewState("0");
		dogDnaParentsCompare.setRunningNumber(add.getRunningNumber());
		dogDnaParentsCompare.setPaymentState("2");
		dogDnaParentsCompare.setApplySource(DnaParentsCompareApplySourceEnum.COMPARE.code());
		dogDnaParentsCompare.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(add.getRunningNumber()));
		dogDnaParentsCompare.setIsCanceled("0");
		super.save(dogDnaParentsCompare);
	}

	/**
	 * @description: 双亲比对列表页面父母犬血统证书号信息显示
	 * @author: laiguanglong
	 * @date: 2017/3/27 15:35
	 */
	public void setParentsInfo(List<DogDnaParentsCompare> list) {
		for (DogDnaParentsCompare vo : list) {
			if (StringUtils.isNotBlank(vo.getBirthCode())) {
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
						.getByBirthCerRegCode(vo.getBirthCode());
				logger.info("12345678990------------- : {}", JSONObjectUtils.toJsonString(dogBirthCertificate));
				if (dogBirthCertificate != null) {
					if (StringUtils.isNotBlank(dogBirthCertificate.getFdogPedigreeCertified())) {
						vo.setFdogPedigreeCertified(dogBirthCertificate.getFdogPedigreeCertified());
					}
					if (StringUtils.isNotBlank(dogBirthCertificate.getMdogPedigreeCertified())) {
						vo.setMdogPedigreeCertified(dogBirthCertificate.getMdogPedigreeCertified());
					}
				}
			}
		}
	}

	/**
	 * 金质证书分页
	 *
	 * @author yuanshuai
	 * @date 2023/6/8 17:48
	 */
	public Page<GoldCertifiedPageResp> findGoldCertifiedPage(GoldCertifiedPageRequest request, String memberCode) {
		Page<GoldCertifiedPageResp> page = new Page<>(request);
		List<GoldCertifiedPageResp> list = dao.findGoldCertifiedPage(request, memberCode);
		page.setList(list);
		page.setCount(request.getCount());
		return page;
	}

	/**
	 * 通过证书号查询
	 *
	 * @author yuanshuai
	 * @date 2023/6/13 16:40
	 */
	public DogDnaParentsCompare getByPedigreeCertified(String pedigreeCertified) {
		if (StringUtils.isBlank(pedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号为空");
		}
		return dao.getByPedigreeCertified(pedigreeCertified);
	}

	@Transactional(readOnly = false)
	public void cancel(DogDnaParentsCompare dogDnaParentsCompare) {
		if (!"2".equals(dogDnaParentsCompare.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已缴费才可撤销");
		}
		if (Global.YES.equals(dogDnaParentsCompare.getIsCanceled())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该DNA存档已是撤销状态");
		}
		// 状态置为撤销
		dogDnaParentsCompare.setIsCanceled(Global.YES);
		dogDnaParentsCompare.preUpdate();
		dao.update(dogDnaParentsCompare);
	}

	/**
	 * 金质证书降级
	 * 
	 * @author yuanshuai
	 * @since 2024/3/12 15:06
	 */
	@Transactional(readOnly = false)
	public void downgrade(DogDnaParentsCompare dogDnaParentsCompare) {
		if (GoldCertifiedStateEnum.DOWNGRADE.code().equals(dogDnaParentsCompare.getGoldCertifiedState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该金质证书已被降级");
		}
		if (0 == dogDnaParentsCompare.getApplySource()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有金质证书可以进行降级操作");
		}
		if (!"2".equals(dogDnaParentsCompare.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有审核状态为不通过时可以降级金质证书");
		}
		if (StringUtils.isBlank(dogDnaParentsCompare.getPedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "仅拥有血统证书犬只可以降级");
		}
		dogDnaParentsCompare.setGoldCertifiedState(GoldCertifiedStateEnum.DOWNGRADE.code());
		dogDnaParentsCompare.preUpdate();
		dao.update(dogDnaParentsCompare);
		dogService.updateGoldCertifiedInfo(dogDnaParentsCompare);
	}

	public Page<DogDnaParentsCompareVO> findPageFB(Page<DogDnaParentsCompare> page,
			DogDnaParentsCompare dogDnaParentsCompare) {

		page = findPage(page, dogDnaParentsCompare);
		// 双亲比对列表页面显示父母犬血统证书号
		setParentsInfo(page.getList());
		//当出生纸编号为空并且父母犬证书号不为空执行以下逻辑
		if (StringUtils.isBlank(dogDnaParentsCompare.getBirthCode())
				&& StringUtils.isNotBlank(dogDnaParentsCompare.getParentDogPedigreeCertified())) {

			//根据证书号查询子犬出生纸信息
			logger.info("-----------11111111111111----- : {}", System.currentTimeMillis());
			List<DogBirthCertificate> childDogInfoByPedigreeCertifiedList = dogBirthCertificateDao.getChildDogInfoByPedigreeCertified(dogDnaParentsCompare.getParentDogPedigreeCertified());
			logger.info("-----------22222222222222----- : {}", System.currentTimeMillis());
			logger.info("------------findPageFB------------childDogInfoByPedigreeCertifiedList : {}", JSONObjectUtils.toJsonString(childDogInfoByPedigreeCertifiedList));
			if (CollectionUtils.isNotEmpty(childDogInfoByPedigreeCertifiedList)) {
				//子犬的出生纸编号
				List<String> birthCerRegCodes = childDogInfoByPedigreeCertifiedList.stream().map(DogBirthCertificate::getBirthCerRegCode).collect(Collectors.toList());
				logger.info("------------birthCerRegCodes------------子犬的出生纸编号 : {}", birthCerRegCodes);
				//用于取父母血统证书号
				Map<String, DogBirthCertificate> stringDogBirthCertificateMap = childDogInfoByPedigreeCertifiedList.stream().filter(item -> StringUtils.isNotBlank(item.getBirthCerRegCode()))
						.collect(Collectors.toMap(DogBirthCertificate::getBirthCerRegCode, Function.identity()));
				dogDnaParentsCompare.setBirthCodes(birthCerRegCodes);
				logger.info("-----------33333333333333----- : {}", System.currentTimeMillis());
				Page<DogDnaParentsCompare> infoByPage = this.findInfoByPage(page, dogDnaParentsCompare);
				logger.info("-----infoByPage----:{}", JSONObjectUtils.toJsonString(infoByPage));
				logger.info("-----------44444444444444----- : {}", System.currentTimeMillis());
				for (DogDnaParentsCompare dnaParentsCompare : infoByPage.getList()) {
					if (StringUtils.isNotBlank(stringDogBirthCertificateMap.get(dnaParentsCompare.getBirthCode()).getFdogPedigreeCertified())) {
						dnaParentsCompare.setFdogPedigreeCertified(stringDogBirthCertificateMap.get(dnaParentsCompare.getBirthCode()).getFdogPedigreeCertified());
					}
					if (StringUtils.isNotBlank(stringDogBirthCertificateMap.get(dnaParentsCompare.getBirthCode()).getMdogPedigreeCertified())) {
						dnaParentsCompare.setMdogPedigreeCertified(stringDogBirthCertificateMap.get(dnaParentsCompare.getBirthCode()).getMdogPedigreeCertified());
					}
				}
				//setParentsInfo(infoByPage.getList());
				if (CollectionUtils.isNotEmpty(infoByPage.getList())) {
					page = infoByPage;
				}
			}
		}




		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));

		// 查询父母审核人姓名
		Set<String> userIdSet = page.getList().stream().filter(a -> StringUtils.isNotBlank(a.getFdogReviewUserId()))
				.map(a -> a.getFdogReviewUserId()).collect(Collectors.toSet());
		Set<String> userIdSet1 = page.getList().stream().filter(a -> StringUtils.isNotBlank(a.getMdogReviewUserId()))
				.map(a -> a.getMdogReviewUserId()).collect(Collectors.toSet());
		userIdSet.addAll(userIdSet1);
		Map<String, String> nameMap = userService.getNameMapByIds(userIdSet.stream().collect(Collectors.toList()));

		Page<DogDnaParentsCompareVO> pageResp = new Page<>();
		List<DogDnaParentsCompareVO> list = page.getList().stream().map(a -> {
			DogDnaParentsCompareVO b = new DogDnaParentsCompareVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			b.setFdogReviewUserName(StringUtils.isNotBlank(a.getFdogReviewUserId())?nameMap.get(a.getFdogReviewUserId()):null);
			b.setMdogReviewUserName(StringUtils.isNotBlank(a.getMdogReviewUserId())?nameMap.get(a.getMdogReviewUserId()):null);
			return b;
		}).collect(Collectors.toList());
		pageResp.setCount(page.getCount());
		pageResp.setPageNo(page.getPageNo());
		pageResp.setPageSize(page.getPageSize());
		pageResp.setList(list);


		return pageResp;
	}

	/**
	 * 金质证书申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String dnaParentsCompareId, String runningNumber) {
		Member member = UserUtils.getLoginMember();
		if (dnaParentsCompareId.contains("'")) {
			dnaParentsCompareId = dnaParentsCompareId.replace("'", "");
		}
		GoldCertifiedPageResp resp = this.dao.findGoldCertifiedDetail(dnaParentsCompareId, member.getMemberCode());
		List<GoldCertifiedPageResp> resultList = new ArrayList<>();
		resultList.add(resp);
		return new RESTResponse("data", resultList);
	}

	public Page<DogDnaParentsCompare> findInfoByPage(Page<DogDnaParentsCompare> page, DogDnaParentsCompare dogDnaParentsCompare) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		dogDnaParentsCompare.setPage(page);
		page.setList(dao.findInfoByPage(dogDnaParentsCompare));
		if((pageNo-1)*pageSize>=page.getCount()){
			page.setList(new ArrayList<DogDnaParentsCompare>(0));
		}
		return page;
	}
}