/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 犬只冷冻精子Entity
 *
 * @author lgl
 * @version 2017-08-24
 */
public class DogFrozenSemen extends DataEntity<DogFrozenSemen> {

    private static final long serialVersionUID = 1L;
    private String semenBatchCode;        // 冷冻精子批次号
    private String dogId;        // 犬只表主键
    private String pedigreeCertified;        // 犬只血统证书号
    private String dogChip;        // 犬只芯片
    private String dogBreed;        // 犬种
    private String dogName;		// 犬名
    private String memberCode;        // 犬主人会员号
    private String memberName;        // 犬主人姓名
    private String businessType;        // 业务类型：申报0；报备1
    private String semenNumber;        // 精子数量
    private Date acquisitionTime;        // 采集时间
    private String runningNumber;        // 流水号
    private String paymentState;        // 付款的状态
    private Date paymentTime;        // 付款时间
    private String reviewState;        // 审核状态
    private Date reviewTime;        // 审核时间
    private String reviewRemarks;        // 审核的意见
    private String processState;        // 流程状态
    private Date processTime;        // 流程变更的时间

    public DogFrozenSemen() {
        super();
    }

    public DogFrozenSemen(String id) {
        super(id);
    }

    public String getSemenBatchCode() {
        return semenBatchCode;
    }

    public void setSemenBatchCode(String semenBatchCode) {
        this.semenBatchCode = semenBatchCode;
    }

    @Length(min = 1, max = 64, message = "犬只表主键长度必须介于 1 和 64 之间")
    public String getDogId() {
        return dogId;
    }

    public void setDogId(String dogId) {
        this.dogId = dogId;
    }

    @Length(min = 1, max = 64, message = "犬只血统证书号长度必须介于 1 和 64 之间")
    public String getPedigreeCertified() {
        return pedigreeCertified;
    }

    public void setPedigreeCertified(String pedigreeCertified) {
        this.pedigreeCertified = pedigreeCertified;
    }

    @Length(min = 1, max = 64, message = "犬只芯片长度必须介于 1 和 64 之间")
    public String getDogChip() {
        return dogChip;
    }

    public void setDogChip(String dogChip) {
        this.dogChip = dogChip;
    }

    @Length(min = 1, max = 64, message = "犬种长度必须介于 1 和 64 之间")
    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

    public String getDogName() {
        return dogName;
    }

    public void setDogName(String dogName) {
        this.dogName = dogName;
    }

    @Length(min = 1, max = 64, message = "犬主人会员号长度必须介于 1 和 64 之间")
    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    @Length(min = 1, max = 64, message = "犬主人姓名长度必须介于 1 和 64 之间")
    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    @Length(min = 1, max = 1, message = "业务类型：申报0；报备1长度必须介于 1 和 1 之间")
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Length(min = 1, max = 2, message = "精子数量长度必须介于 1 和 2 之间")
    public String getSemenNumber() {
        return semenNumber;
    }

    public void setSemenNumber(String semenNumber) {
        this.semenNumber = semenNumber;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getAcquisitionTime() {
        return acquisitionTime;
    }

    public void setAcquisitionTime(Date acquisitionTime) {
        this.acquisitionTime = acquisitionTime;
    }

    @Length(min = 1, max = 100, message = "流水号长度必须介于 1 和 100 之间")
    public String getRunningNumber() {
        return runningNumber;
    }

    public void setRunningNumber(String runningNumber) {
        this.runningNumber = runningNumber;
    }

    @Length(min = 1, max = 20, message = "付款的状态长度必须介于 1 和 20 之间")
    public String getPaymentState() {
        return paymentState;
    }

    public void setPaymentState(String paymentState) {
        this.paymentState = paymentState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    @Length(min = 1, max = 20, message = "审核状态长度必须介于 1 和 20 之间")
    public String getReviewState() {
        return reviewState;
    }

    public void setReviewState(String reviewState) {
        this.reviewState = reviewState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    @Length(min = 1, max = 200, message = "审核的意见长度必须介于 1 和 200 之间")
    public String getReviewRemarks() {
        return reviewRemarks;
    }

    public void setReviewRemarks(String reviewRemarks) {
        this.reviewRemarks = reviewRemarks;
    }

    @Length(min = 1, max = 20, message = "流程状态长度必须介于 1 和 20 之间")
    public String getProcessState() {
        return processState;
    }

    public void setProcessState(String processState) {
        this.processState = processState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getProcessTime() {
        return processTime;
    }

    public void setProcessTime(Date processTime) {
        this.processTime = processTime;
    }


    //后台查询条件
    private String pedigreeCertifiedAndDogChipLike;        // 血统证书号和芯片号模糊查询条件
    private String memberCodeAndMemberNameLike;        // 会员号和会员姓名模糊查询条件
    private Date createDateStart;// 申请时间开始
    private Date createDateEnd;// 申请时间结束

    public String getPedigreeCertifiedAndDogChipLike() {
        return pedigreeCertifiedAndDogChipLike;
    }

    public void setPedigreeCertifiedAndDogChipLike(String pedigreeCertifiedAndDogChipLike) {
        this.pedigreeCertifiedAndDogChipLike = pedigreeCertifiedAndDogChipLike;
    }

    public String getMemberCodeAndMemberNameLike() {
        return memberCodeAndMemberNameLike;
    }

    public void setMemberCodeAndMemberNameLike(String memberCodeAndMemberNameLike) {
        this.memberCodeAndMemberNameLike = memberCodeAndMemberNameLike;
    }

    public Date getCreateDateStart() {
        return createDateStart;
    }

    public void setCreateDateStart(Date createDateStart) {
        this.createDateStart = createDateStart;
    }

    public Date getCreateDateEnd() {
        return createDateEnd;
    }

    public void setCreateDateEnd(Date createDateEnd) {
        this.createDateEnd = createDateEnd;
    }

    //后台展示字段
    private Dog dog;
    private String breedCnName;
    private List<Object> originalSemenCode;
    private String old;
    private String newadd;

    public Dog getDog() {
        return dog;
    }

    public void setDog(Dog dog) {
        this.dog = dog;
    }

    public String getBreedCnName() {
        return breedCnName;
    }

    public void setBreedCnName(String breedCnName) {
        this.breedCnName = breedCnName;
    }

    public List<Object> getOriginalSemenCode() {
        return originalSemenCode;
    }

    public void setOriginalSemenCode(List<Object> originalSemenCode) {
        this.originalSemenCode = originalSemenCode;
    }

    public String getOld() {
        return old;
    }

    public void setOld(String old) {
        this.old = old;
    }

    public String getNewadd() {
        return newadd;
    }

    public void setNewadd(String newadd) {
        this.newadd = newadd;
    }

    public String getBusinessState(){
        if("0".equals(businessType)){
            if("0".equals(reviewState)){
                return "待采集";
            }else if("1".equals(reviewState)){
                return "已通过";
            }
        }else if("1".equals(businessType)){
            if("0".equals(reviewState)){
                return "待审核";
            }else if("1".equals(reviewState)){
                return "已通过";
            }else if("2".equals(reviewState)){
                return "未通过";
            }
        }
        return "";
    }
}