/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬DNAEntity
 *
 * @author lgl
 * @version 2016-08-08
 */
public class DogDna extends DataEntity<DogDna> {

    private static final long serialVersionUID = 1L;
    private String dogId;        // 犬id
    // 检测类型（0血样，1唾液）
    private Integer detectionType;
    // 采样包编号
    private String samplingCode;
    // 激活状态（0关闭1激活）
    private Integer activeState;
    private String sumZu;        // sum_zu
    private String dnaResult;        // DNA鉴定结果
    private String dnaResultRemark;        // DNA鉴定结果备注
    private String dnaCode;        // DNA样本登记号码

    private String pedigreeCertifiedCode;        // 血统证书号
    private String nameCn;        // 中文姓名
    private Date birthdate;        // 出生日期
    private String gender;        // 性别

    private String dnaArchiveId;        //DNA存档id
    private String dogBreed;        // 种类

    private Dog dog;


    public Dog getDog() {
        return dog;
    }

    public void setDog(Dog dog) {
        this.dog = dog;
    }

    public DogDna() {
        super();
    }

    public DogDna(String id) {
        super(id);
    }

    @Length(min = 0, max = 64, message = "犬id长度必须介于 0 和 64 之间")
    public String getDogId() {
        return dogId;
    }

    public void setDogId(String dogId) {
        this.dogId = dogId;
    }

    public Integer getDetectionType() {
        return detectionType;
    }

    public void setDetectionType(Integer detectionType) {
        this.detectionType = detectionType;
    }

    public String getSamplingCode() {
        return samplingCode;
    }

    public void setSamplingCode(String samplingCode) {
        this.samplingCode = samplingCode;
    }

    public Integer getActiveState() {
        return activeState;
    }

    public void setActiveState(Integer activeState) {
        this.activeState = activeState;
    }

    @Length(min = 0, max = 10, message = "sum_zu长度必须介于 0 和 10 之间")
    public String getSumZu() {
        return sumZu;
    }

    public void setSumZu(String sumZu) {
        this.sumZu = sumZu;
    }

    @Length(min = 0, max = 500, message = "DNA鉴定结果长度必须介于 0 和 500 之间")
    public String getDnaResult() {
        return dnaResult;
    }

    public void setDnaResult(String dnaResult) {
        this.dnaResult = dnaResult;
    }

    @Length(min = 0, max = 200, message = "DNA鉴定结果备注长度必须介于 0 和 200 之间")
    public String getDnaResultRemark() {
        return dnaResultRemark;
    }

    public void setDnaResultRemark(String dnaResultRemark) {
        this.dnaResultRemark = dnaResultRemark;
    }

    @Length(min = 0, max = 64, message = "DNA样本登记号码长度必须介于 0 和 64 之间")
    public String getDnaCode() {
        return dnaCode;
    }

    public void setDnaCode(String dnaCode) {
        this.dnaCode = dnaCode;
    }

    public String getPedigreeCertifiedCode() {
        return pedigreeCertifiedCode;
    }

    public void setPedigreeCertifiedCode(String pedigreeCertifiedCode) {
        this.pedigreeCertifiedCode = pedigreeCertifiedCode;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public Date getBirthdate() {
        return birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getDnaArchiveId() {
        return dnaArchiveId;
    }

    public void setDnaArchiveId(String dnaArchiveId) {
        this.dnaArchiveId = dnaArchiveId;
    }

    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

}