/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鉴定附表Entity
 * @author 鉴定附表
 * @version 2016-11-15
 */
public class DogAppraisalAppraiser extends DataEntity<DogAppraisalAppraiser> {
	
	private static final long serialVersionUID = 1L;
	private String pedigreeCertified;		// pedigree_certified
	private String identifySite;		// identify_site
	private String identifier1;		// identifier1
	private String identifier2;		// identifier2
	private String identifier3;		// identifier3
	private Date identifyTime;		// identify_time
	private Date createTime;		// create_time
	private Date updateTime;		// update_time
	
	public DogAppraisalAppraiser() {
		super();
	}

	public DogAppraisalAppraiser(String id){
		super(id);
	}

	@Length(min=1, max=50, message="pedigree_certified长度必须介于 1 和 50 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}
	
	@Length(min=0, max=50, message="identify_site长度必须介于 0 和 50 之间")
	public String getIdentifySite() {
		return identifySite;
	}

	public void setIdentifySite(String identifySite) {
		this.identifySite = identifySite;
	}
	
	@Length(min=0, max=50, message="identifier1长度必须介于 0 和 50 之间")
	public String getIdentifier1() {
		return identifier1;
	}

	public void setIdentifier1(String identifier1) {
		this.identifier1 = identifier1;
	}
	
	@Length(min=0, max=50, message="identifier2长度必须介于 0 和 50 之间")
	public String getIdentifier2() {
		return identifier2;
	}

	public void setIdentifier2(String identifier2) {
		this.identifier2 = identifier2;
	}
	
	@Length(min=0, max=50, message="identifier3长度必须介于 0 和 50 之间")
	public String getIdentifier3() {
		return identifier3;
	}

	public void setIdentifier3(String identifier3) {
		this.identifier3 = identifier3;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getIdentifyTime() {
		return identifyTime;
	}

	public void setIdentifyTime(Date identifyTime) {
		this.identifyTime = identifyTime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}
	
}