/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogBloodSave;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * DNA血样留存DAO接口
 *
 * @author lgl
 * @version 2016-11-24
 */
@MyBatisDao
public interface DogBloodSaveDao extends CrudDao<DogBloodSave> {
	public DogBloodSave getByBirthCode(@Param("birthCode") String birthCode);

	/**
	 * @Description 根据血统证书号获取信息
	 * @author yuanshuai
	 * @date 2020/12/1 11:00
	 */
	DogBloodSave getByPedigreeCertifiedCode(@Param("pedigreeCertifiedCode") String pedigreeCertifiedCode);

	public DogBloodSave getByBirthCodeAndNullRunningNumber(@Param("birthCode") String birthCode);

	/**
	 * @Description： 根据赛场鉴定编号查询
	 *
	 * @author: yuanshuai
	 * @date: 2018/9/28 10:55
	 */
	public DogBloodSave getByShowAppraisalCode(@Param("showAppraisalCode") String showAppraisalCode);

	/**
	 * @description: 根据id进行物理删除
	 * @author: laiguanglong
	 * @date: 2016/12/20 17:44
	 */
	int deleteYes(DogBloodSave dogBloodSave);

	// 根据国外证书号查询
	public DogBloodSave getByOverPedigreeCode(@Param("overPeidgreeCode") String overPeidgreeCode);
	public DogBloodSave getByRunningMumber(@Param("runningNumber") String runningNumber);

	void refundDogBloodSave(@Param("vo") DogBloodSave vo, @Param("ids") Set<String> ids,
			@Param("businessTable") String businessTable);

	void refundDogBloodSaveFAll(@Param("vo") DogBloodSave vo);

	public DogBloodSave getByParams(@Param("vo") DogBloodSave s, @Param("isCheckUnpaid") Boolean isCheckUnpaid);
	public DogBloodSave getByParams2(@Param("vo") DogBloodSave s, @Param("isCheckUnpaid") Boolean isCheckUnpaid);


	List<DogBloodSave> getListDogDnaAndBload(DogBloodSave dogBloodSave);
	// 血统证书号
	String getRunningNumber(@Param("pedigreeCertifiedCode") String pedigreeCertifiedCode,
			@Param("pedigreeCertifiedEn") String pedigreeCertifiedEn);

    DogBloodSave getById(@Param("id") String id);
    
    public List<DogBloodSave> findList1(DogBloodSave entity);
    
    public int updateOrg(@Param("birthCode") String birthCode, @Param("orgId") String orgId);
    
    public DogBloodSave getOneByParam(@Param("birthCode")String birthCode,@Param("overseasPedigreeCertified")String overseasPedigreeCertified,
    		@Param("showAppraisalCode")String showAppraisalCode,@Param("pedigreeCertified")String pedigreeCertified);

	/**
	 * 修改DNA存档采集状态
	 *
	 * @author yuanshuai
	 * @since 2024/1/11 15:09
	 */
	void updateIsOec(DogBloodSave dogBloodSave);
}