/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛场失格评价Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class ContestGradeDisqualified extends DataEntity<ContestGradeDisqualified> {
	
	private static final long serialVersionUID = 1L;
	private String gradeDisqualifiedNo;		// 编号
	private String name;		// 名称
	private String languageNo;		// 语言
	
	public ContestGradeDisqualified() {
		super();
	}

	public ContestGradeDisqualified(String id){
		super(id);
	}

	@Length(min=1, max=11, message="编号长度必须介于 1 和 11 之间")
	public String getGradeDisqualifiedNo() {
		return gradeDisqualifiedNo;
	}

	public void setGradeDisqualifiedNo(String gradeDisqualifiedNo) {
		this.gradeDisqualifiedNo = gradeDisqualifiedNo;
	}
	
	@Length(min=1, max=255, message="名称长度必须介于 1 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=1, max=11, message="语言长度必须介于 1 和 11 之间")
	public String getLanguageNo() {
		return languageNo;
	}

	public void setLanguageNo(String languageNo) {
		this.languageNo = languageNo;
	}
	
}