package com.cku.oa.components.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

import com.cku.oa.components.rule.validation.dog.DogCondition;
import com.cku.oa.components.rule.validation.member.MemberCondition;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;

public class DroolsEngine {
	//定义校验工具类
	private KieContainer kieContainer; 
	private static DroolsEngine engine;
	private KieServices kieServices;
	private KieContainer getContainer(){
		if(kieContainer == null){
			kieServices = KieServices.Factory.get();
			kieContainer = kieServices.getKieClasspathContainer();
		}
		return kieContainer;
	}
	
	private DroolsEngine(){
		
	}
	public static DroolsEngine getEngine(){
		if(engine == null){
			engine = new DroolsEngine();
		}
		return engine;
	}
	
	
	private void getValidation(KieSession kieSession){
		kieSession.insert(SpringContextHolder.getBean("memberCondition"));
		kieSession.insert(SpringContextHolder.getBean("kennelCondition"));
		kieSession.insert(SpringContextHolder.getBean("dogCondition"));
		kieSession.insert(SpringContextHolder.getBean("dogNewbornCondition"));
	}
	
	/**
	 * 数据校验类型的规则执行，分步执行，执行多步
	 * @param kSessionName drools规则的session名
	 * @param agendaGroups 规则的分组
	 * @param params 校验的入参
	 */
	public ValidateResult validateBySteps(String kSessionName,List<String> agendaGroups,Object param){
		ValidateResult validateResult = new ValidateResult();
		KieSession kSession = getContainer().newKieSession(kSessionName);
		kieServices.getLoggers().newConsoleLogger(kSession);
		kSession.insert(param);
		kSession.insert(validateResult);
		getValidation(kSession);
		
		for(String s:agendaGroups){
			kSession.getAgenda().getAgendaGroup(s).setFocus();
		}
		
		kSession.fireAllRules();
		kSession.dispose();
		if(validateResult.getErrorMessage().size() == 0 && validateResult.getErrorCode().size() == 0){
			validateResult.setSuccess(true);
		}
		return validateResult;
	}
	
	/**
	 * 数据校验类型的规则执行,分步执行，只执行一步
	 * @param kSessionName drools规则的session名
	 * @param agendaGroup 规则分组执行的组
	 * @param params 规则引擎入参
	 * 
	 */
	public ValidateResult validateByStep(String kSessionName,String agendaGroup,Object param){
		ValidateResult validateResult = new ValidateResult();
		KieSession kSession = getContainer().newKieSession(kSessionName);
		kieServices.getLoggers().newConsoleLogger(kSession);
		kSession.insert(param);
		getValidation(kSession);
		kSession.insert(validateResult);
		kSession.getAgenda().getAgendaGroup(agendaGroup).setFocus();
		kSession.fireAllRules();
		kSession.dispose();
		if(validateResult.getErrorMessage().size() == 0 && validateResult.getErrorCode().size() == 0){
			validateResult.setSuccess(true);
		}
		return validateResult;
	}
	
	/**
	 * 查询目前定义好的规则
	 * @return
	 */
	public Map<String,Collection<Rule>> getRuleDefine(){
		Map<String,Collection<Rule>> ruleDefines = new HashMap<String,Collection<Rule>>();
		
		//查询所有目前在使用的规则
		Collection<String> names = kieContainer.getKieBaseNames();
		for(String name:names){
			KieBase base = kieContainer.getKieBase(name);
			List<Rule> list = new ArrayList<Rule>();
			System.out.println(name+":");
			Collection<KiePackage> packages = base.getKiePackages();
			for(KiePackage p:packages){
				Collection<Rule> rules = p.getRules();
				ruleDefines.put(name, rules);
			}
		}
		return ruleDefines;
	}
}
