package com.cku.oa.breeder.web;

import com.cku.oa.breeder.entity.Pup;
import com.cku.oa.breeder.service.PupService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 幼犬信息表Controller
 *
 * @author lgl
 * @version 2018-01-12
 */
@Controller
@RequestMapping(value = "${adminPath}/pup/pup")
public class PupController extends BaseController {

    @Autowired
    private PupService pupService;

    @ModelAttribute
    public Pup get(@RequestParam(required = false) String id) {
        Pup entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = pupService.get(id);
        }
        if (entity == null) {
            entity = new Pup();
        }
        return entity;
    }

    @RequiresPermissions("pup:pup:view")
    @RequestMapping(value = {"list", ""})
    public String list(Pup pup, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<Pup> page = pupService.findPage(new Page<Pup>(request, response), pup);
        model.addAttribute("page", page);
        return "breeder/pup/pupList";
    }

    @RequiresPermissions("pup:pup:view")
    @RequestMapping(value = "form")
    public String form(Pup pup, Model model) {
        model.addAttribute("pup", pup);
        return "breeder/pup/pupForm";
    }

    @RequiresPermissions("pup:pup:edit")
    @RequestMapping(value = "save")
    public String save(Pup pup, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, pup)) {
            return form(pup, model);
        }
        pupService.save(pup);
        addMessage(redirectAttributes, "保存幼犬信息表成功");
        return "redirect:" + Global.getAdminPath() + "/pup/pup/?repage";
    }

    @RequiresPermissions("pup:pup:edit")
    @RequestMapping(value = "delete")
    public String delete(Pup pup, RedirectAttributes redirectAttributes) {
        pupService.delete(pup);
        addMessage(redirectAttributes, "删除幼犬信息表成功");
        return "redirect:" + Global.getAdminPath() + "/pup/pup/?repage";
    }

}