package com.cku.config;

import org.springframework.context.annotation.Configuration;

import com.thinkgem.jeesite.common.config.Global;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.*;
import org.springframework.context.annotation.Bean;

/**
 * 延迟交换器和队列
 */
@Configuration
public class DelayedExchangeConfig {

	protected Logger logger = LoggerFactory.getLogger(getClass());

	public static final String EXCHANGE_NAME = "groomerExamDelayedExchange";

	public static final String QUEUE_NAME = "groomer.exam.delayed.queue";

	public static final String ROUTING_KEY = "groomer.exam.delayed.routing.key";

	@Bean
	public CustomExchange delayedExchange() {
		Map<String, Object> arguments = new HashMap<>();
		arguments.put("x-delayed-type", "direct");
		return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", // 消息类型
				true, // 是否持久化
				false, arguments); // 是否自动删除
	}

	@Bean
	public Queue delayedQueue() {
		String queue_name = DelayedExchangeConfig.QUEUE_NAME;
		if (Global.isDevMode()) {
			String prefix = Global.getConfig("rabbitmq.queue.name.prefix");
			if (StringUtils.isNotBlank(prefix)) {
				logger.debug("++++++++prefix:" + prefix);
				queue_name = prefix + "." + queue_name;
			}
		}
		return QueueBuilder.durable(queue_name).withArgument("x-delayed-type", "direct").build();
	}

	@Bean
	public Binding delayedBinding(Queue delayedQueue, CustomExchange delayedExchange) {
		String routing_key = ROUTING_KEY;
		if (Global.isDevMode()) {
			String prefix = Global.getConfig("rabbitmq.queue.name.prefix");
			if (StringUtils.isNotBlank(prefix)) {
				logger.debug("++++++++prefix:" + prefix);
				routing_key = prefix + "." + routing_key;
			}
		}
		return BindingBuilder.bind(delayedQueue()).to(delayedExchange()).with(routing_key).noargs();
	}

}