//注册页面
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //用户邮箱
        me.email = ko.observable("");
        //手机号码
        me.mobile = ko.observable("");
        //用户密码
        me.newPassword = ko.observable("");
        //重复密码
        me.douPassword = ko.observable("");
        //用户名称
        me.name = ko.observable("");
        //帐号登录名
        me.loginName = ko.observable("");
        //验证码
        me.validateCode = ko.observable("");
        //阅读并接受《CKU用户协议》start by zhuoHeng
        me.agreementFlag = ko.observable(false);
        me.vaildAgreement = function(){
        	if($("#showDownAgreement").attr('class') == 'radio'){
        		$("#showDownAgreement").removeClass();
        		$("#showDownAgreement").addClass("radio checked");
        		me.agreementFlag(true);
        	}else if($("#showDownAgreement").attr('class') == 'radio checked'){
        		$("#showDownAgreement").removeClass();
        		$("#showDownAgreement").addClass("radio");
        		me.agreementFlag(false);
        	}
        }
        //阅读并接受《CKU用户协议》end by zhuoHeng
        
        me.validateCodeSrc = ko.observable("");
        //校验用户名称
        me.downName = function(){
            $("#showDownName").addClass("loginshadow");
        }
        me.vaildNameFlag = ko.observable(false);
        me.vaildName = function(data){
            $("#showDownName").removeClass("loginshadow");
            if(util.isVal(me.name())==""){
                $("#vaildNameDiv").html("<p class=\"yellow\"><span></span><em>用户名不能为空</em></p>");
                me.vaildNameFlag(false);
            }else{
                $("#vaildNameDiv").html("<p class=\"green\"><span></span><em>用户名可用</em></p>");
                me.vaildNameFlag(true);
            }
        }
        //校验登陆用户名
        me.downLoginName = function(){
            $("#showDownLoginName").addClass("loginshadow");
        }
        me.vaildLoginNameFlag = ko.observable(false);
        me.vaildLoginName = function(data){
            $("#showDownLoginName").removeClass("loginshadow");
            if(util.isVal(me.loginName())==""){
                $("#vaildLoginNameDiv").html("<p class=\"yellow\"><span></span><em>帐号登录名不能为空</em></p>");
                me.vaildLoginNameFlag(false);
            }else{
                $("#vaildLoginNameDiv").html("<p class=\"green\"><span></span><em>帐号登录名可用</em></p>");
                me.vaildLoginNameFlag(true);
            }
        }
        //校验邮箱
        me.downEmail = function(){
            $("#showDownEmail").addClass("loginshadow");
        }
        me.vaildEmailFlag = ko.observable(false);
        me.vaildEmail = function(data){
            $("#showDownEmail").addClass("loginshadow");
            if(!util.isEmail(me.email())){
                $("#vaildEmailDiv").html("<p class=\"yellow\"><span></span><em>邮箱账号无效</em></p>");
                me.vaildEmailFlag(false);
            }else{
                $("#vaildEmailDiv").html("<p class=\"green\"><span></span><em>邮箱账号可用</em></p>");
                me.vaildEmailFlag(true);
            }
        }
        //校验手机号码
        me.downMobile = function(){
            $("#showDownMobile").addClass("loginshadow");
        }
        me.vaildMobileFlag = ko.observable(false);
        me.vaildMobile = function(data){
            $("#showDownMobile").addClass("loginshadow");
            if(!util.isMobile(me.mobile())){
                $("#vaildMobileDiv").html("<p class=\"yellow\"><span></span><em>手机号码无效</em></p>");
                me.vaildMobileFlag(false);
            }else{
                $("#vaildMobileDiv").html("<p class=\"green\"><span></span><em>手机号码可用</em></p>");
                me.vaildMobileFlag(true);
            }
        }
        //校验密码
        me.downPassword = function(){
            $("#showDownPassword").addClass("loginshadow");
        }
        me.vaildNewPasswordFlag = ko.observable(false);
        me.vaildNewPassword = function(data){
            $("#showDownPassword").addClass("loginshadow");
            if(util.isVal(me.newPassword())=="" || util.isVal(me.newPassword()).length<8 || util.isVal(me.newPassword()).search(/[a-zA-Z]+/)==-1){
                $("#vaildNewPasswordDiv").html("<p class=\"yellow\"><span></span><em>密码长度大于8位,使用字母与数字混合</em></p>");
                me.vaildNewPasswordFlag(false);
            }else{
                $("#vaildNewPasswordDiv").html("<p class=\"green\"><span></span><em>密码可用</em></p>");
                me.vaildNewPasswordFlag(true);
            }
        }
        //校验再次密码
        me.downDouPassword = function(){
            $("#showDownDouPassword").addClass("loginshadow");
        }
        me.vaildDouPasswordFlag = ko.observable(false);
        me.vaildDouPassword = function(data){
            $("#showDownDouPassword").removeClass("loginshadow");
            if(util.isVal(me.newPassword())=="" || util.isVal(me.newPassword()).length<8 || util.isVal(me.newPassword()).search(/[a-zA-Z]+/)==-1) {
                $("#vaildDouPasswordDiv").html("<p class=\"yellow\"><span></span><em>密码长度大于8位,使用字母与数字混合</em></p>");
            }else if(me.newPassword()!=me.douPassword()){
                $("#vaildDouPasswordDiv").html("<p class=\"yellow\"><span></span><em>两次密码不相等</em></p>");
                me.vaildDouPasswordFlag(false);
            }else{
                $("#vaildDouPasswordDiv").html("<p class=\"green\"><span></span><em>两次密码相同</em></p>");
                me.vaildDouPasswordFlag(true);
            }
        }
        //校验验证码
        me.downCode = function(){
            $("#showDownCode").removeClass("lastdown");
        }
        me.validateCodeFlag = ko.observable(false);
        me.validateCodeFun = function(data){
            $("#showCode").addClass("lastdown");
            if(util.isVal(me.validateCode())==""){
                $("#validateCodeDiv").html("<p class=\"yellow\"><span></span><em>验证码不能为空</em></p>");
                me.validateCodeFlag(false);
            }else{
                $("#validateCodeDiv").html("<p class=\"green\"><span></span><em>验证码可用</em></p>");
                me.validateCodeFlag(true);
            }
        }
        /**
         * 注册
         */
        me.register = function(){
            var flag = me.vaildNameFlag() && me.vaildLoginNameFlag() && me.vaildEmailFlag() &&me.vaildMobileFlag() && me.vaildNewPasswordFlag() && me.vaildDouPasswordFlag() && me.validateCodeFlag();
            if(flag){
            	if(me.agreementFlag()){//是否勾选了阅读并接受《CKU用户协议》
            		var sendData = {};
                    sendData["email"] = me.email();
                    sendData["mobile"] = me.mobile();
                    sendData["newPassword"] = me.newPassword();
                    sendData["name"] = me.name();
                    sendData["loginName"] = me.loginName();
                    sendData["validateCode"] = me.validateCode();
                    util.sendAjax({
                        url:'open/register',
                        data:JSON.stringify(sendData),
                        async:false,
                        type:'POST',
                        cache:false,
                        success:function(json){
                            if(json.rc==0){
                                layer.msg("注册成功！");
                                location.href = location.href.split("#")[0]+"#/login/successregister?email="+me.email();
                            }else{
                                me.validateCodeSrc("/oa-web/api/v1/open/validateCodeNew?_="+new Date().getTime());
                                $("#validateCodeDiv").html("<p>请输入验证码</p>");
                                me.validateCode("");
                                layer.msg("注册失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                            }

                        }
                    });
            	} else {
            		layer.msg("请先阅读并接受《CKU用户协议》");
            	}
            }
        }
        $(function(){
            me.validateCodeSrc("/oa-web/api/v1/open/validateCodeNew?_="+new Date().getTime());
            document.onkeydown=function(event){
                var e = event || window.event || arguments.callee.caller.arguments[0];
                if(e && e.keyCode==13){ // enter 键
                    var val = $("#yzm").val();
                    if(util.isVal(val)!=""){
                        me.validateCode($("#yzm").val());
                        me.validateCodeFlag(true);
                    }
                    me.register();
                }
            };
        })
        context.app.loading(false);
    }
});