//牵犬师活动列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //活动地点
        me.showAddress = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        // 活动类型:牵犬师考试0；精英大赛1；讲座3；其他4；训犬师考试5；训犬师比赛6
        me.showType = ko.observable("");
        //活动类型
        me.showText = ko.observable("全部");
        //活动名称
        me.showName = ko.observable("");
        //默认隐藏
        me.isShouldShow = ko.observable(false);
        //活动类型的显隐藏
        me.isShow = function(){
            me.isShouldShow(!me.isShouldShow())
        };
        //计时器
        me.timeRun = null;
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findhandlerShowList(false);
        }
        //下一页
        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findhandlerShowList(false);
        }
        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findhandlerShowList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findhandlerShowList(false);
            }
            return false;
        }
        //活动类型的选择
        me.witchType = function(type){
            $("#activityType li").removeAttr("class");
            $("#"+type).attr("class","active");
            switch(type){
                case "testA":
                    me.showType("");
                    break;
                case "testQ":
                    me.showType("0");
                    break;
                case "testJ":
                    me.showType("1");
                    break;
                case "chair":
                    me.showType("3");
                    break;
                case "testX":
                    me.showType("5");
                    break;
                case "matchX":
                    me.showType("6");
                    break;
                default:
                    me.showType("4");
                    break;
            }
            var typeText = $("#"+type).children("a").text();
            me.showText(typeText);
            me.isShouldShow(!me.isShouldShow());
        }
        //说明 须知 简章的打开关闭
        me.description = function(data,event){
            if($(event.target).siblings(".pop").css("display")=="none"){
                $(event.target).siblings(".pop").css("display","block");
            }else{
                $(event.target).siblings(".pop").css("display","none");
            }
        }
        me.closeDescription = function(data,event){
            $(event.target).parents(".pop").css("display","none");
        }
        /**
         * 牵犬师活动列表查询方法
         */
        me.findhandlerShowList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["showAddress"] = me.showAddress();
            sendData["showType"] = me.showType();
            sendData["showName"] = me.showName();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'handler/handlerShow',
                data:sendData,
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length>0) {
                            var list = data.list;
                            $.each(list, function (index, item) {
                                var durTime = new Date(new Date(util.formatDateLong(item.registerEndTime))).getTime() - new Date().getTime();
                                var showTime = util.endTime(durTime);
                                item["showDurTime"] = ko.observable(showTime);
                            });
                            me.listData(list);
                        }
                        me.timeRun = setInterval(me.setTime,10000);
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),data.total,me.pageSize()));
                    }
                }
            });

        }
        //报名跳转
        me.register = function(data){
            var id = data.id;
            var showType = data.showType;
            var showCode = data.showCode;
            var sendData = {};
            sendData["showCode"] = showCode;
            util.sendAjax({
                url:'handler/apply',
                data:sendData,
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        location.href = "#/qualification/p_handlerRegister?id="+id+"&showType="+showType;
                    }else{
                        layer.msg(data.msg);
                    }
                }
            });
        }
        //截止日期
        me.setTime = function(){
            if(me.listData().length>0) {
                var list = me.listData();
                $.each(list, function (index, item) {
                    var durTime = new Date(new Date(util.formatDateLong(item.registerEndTime))).getTime() - new Date().getTime();
                    var showTime = util.endTime(durTime);
                    item.showDurTime(showTime);
                });
                me.listData(list);
            }
        }
        $(function(){
            me.findhandlerShowList(false);
        });

        context.app.loading(false);
        context.app.isShop(false);
    }
});
