<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只激活管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a>犬只激活管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogActivation" action="${ctxPartner}/dogActivation/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>芯片号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>申请时间：</label>
				<input name="beginCreateDate"  type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogActivation.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogActivation.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns" style="float:right"><a  class="btn btn-primary"  href="${ctxPartner}/dogActivation/form" >申请</a></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>芯片号</th>
				<th>办理时间</th>
				<th>激活状态</th>
				<th>缴费</th>
				<%--<th>操作</th>--%>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogActivation">
			<tr>
				<td>
					${fns:escapeHtml(dogActivation.birthCode)}
				</td>
				<td>
					${fns:escapeHtml(dogActivation.identificationFlag)}
				</td>
				<td>
					<fmt:formatDate value="${dogActivation.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(dogActivation.reviewState)}
				</td>
				<td>
					<c:if test="${dogActivation.paymentState=='1' }">
						<a style="color:red;" href="${ctxPartner}/dogActivation/toOrder?id=${dogActivation.id}">缴费</a>
					</c:if>
					<c:if test="${dogActivation.paymentState=='2' }">
						<font style="color:green;">${fns:getDictLabel(dogActivation.paymentState, 'user_payment_state', '')}</font>
					</c:if>
				</td>
				<%--<td>--%>
					<%--<c:if test="${dogActivation.paymentState=='1' }">--%>
						<%--<a style="color:red;" href="${ctxPartner}/dogActivation/delActivition?id=${dogActivation.id}">删除</a>--%>
					<%--</c:if>--%>
				<%--</td>--%>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>