<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>俱乐部打印重置管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/sysOrgPrint/">俱乐部打印重置列表</a></li>
		<shiro:hasPermission name="sys:sysOrgPrint:edit"><li><a href="${ctx}/sys/sysOrgPrint/form">俱乐部打印重置添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="sysOrgPrint" action="${ctx}/sys/sysOrgPrint/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>俱乐部id：</label>
				<form:input path="orgId" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>俱乐部会员号：</label>
				<form:input path="orgCode" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>计算时间：</label>
				<input name="validDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${sysOrgPrint.validDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
			</li>
			<li><label>重置次数：</label>
				<form:input path="restPrintCode" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>俱乐部id</th>
				<th>俱乐部会员号</th>
				<th>计算时间</th>
				<th>重置次数</th>
				<shiro:hasPermission name="sys:sysOrgPrint:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sysOrgPrint">
			<tr>
				<td><a href="${ctx}/sys/sysOrgPrint/form?id=${sysOrgPrint.id}">
					${sysOrgPrint.orgId}
				</a></td>
				<td>
					${sysOrgPrint.orgCode}
				</td>
				<td>
					<fmt:formatDate value="${sysOrgPrint.validDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${sysOrgPrint.restPrintCode}
				</td>
				<shiro:hasPermission name="sys:sysOrgPrint:edit"><td>
    				<a href="${ctx}/sys/sysOrgPrint/form?id=${sysOrgPrint.id}">修改</a>
					<a href="${ctx}/sys/sysOrgPrint/delete?id=${sysOrgPrint.id}" onclick="return confirmx('确认要删除该俱乐部打印重置吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>