<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>单犬种俱乐部管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<div style="padding:10px;">
	<form:form id="searchForm" modelAttribute="org" action="${ctx}/sys/singleOrg/search" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>机构名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="50" class="input-small"/>
			</li>
			<li><label>合作编号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-small"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>机构名称</th>
				<th>合作编号</th>
				<th>状态</th>
				<th>截止日期</th>
				<shiro:hasPermission name="sys:user:member:edit"><th>选择</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="org">
			<tr>
				<td>
					${org.name}
				</td>
				<td>
						${org.memberCode }
				</td>

				<td>
					<c:if test="${org.endDate gt currentDate}" > <font color="green">开放</font></c:if>
					<c:if test="${org.endDate lt currentDate}" > <font color="red">关闭</font> </c:if>
					<c:if test="${org.endDate eq currentDate}" > 今天关闭 </c:if>
				</td>
				<td>
					<fmt:formatDate value="${org.endDate}" type="date" pattern="yyyy-MM-dd "/>

				</td>
				<td>
    					<a href="#" onclick="select('${fns:escapeHtml(org.id) }','${fns:escapeHtml(org.name)}')">选择</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<script type="text/javascript">
		function select(id,name){
			var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
			var org = {
					id:id,
					name:name
			}
			if(parent.document.getElementById("mainFrame").contentWindow.searchSingleClubCallback != undefined){
				parent.document.getElementById("mainFrame").contentWindow.searchSingleClubCallback(org);
			}
			parent.layer.close(index);
		}
	</script>
</body>
</html>