<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>芯片发放记录管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		let chipPrefix = '${orgCodePrefix}';

		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					var dds =document.getElementsByName("cardNo");
					for(var i=0;i<dds.length;i++)
				       {
				          for(var j=i+1;j<dds.length;j++)
				          {
				            if(dds[i].value==dds[j].value)
				            {
				            	if(dds[i].value!=''){
				                	$.jBox.alert("此芯片重复<"+dds[j].value+">");
				                	return false;
				            	}	
				            }
				           
				          }
				       } 
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			//芯片前缀点击事件
			$("input[name='chipPrefix']").click(function () {
				chipPrefix = $(this).val();
				$("span[class='chipPrefixClass']").html(chipPrefix);
				clearCardNo();
			});
		});
		
		//清空芯片号
		function clearCardNo(){
			var dds = document.getElementsByName("cardNo");
			for(var i=0;i<dds.length;i++){
				dds[i].value="";
		    }
		}
		
		function addItem(){
			var value=$("#chipCount").val();
			try{
				value= parseInt(value);
				if(value==0){
					$("#chipArea").html("<input style='width:70px;' class='required' type='hidden' value='null'  name='cardNo'/>")
				}else{
					$("#chipArea").html("");
					for(var i=0;i<value;i++){
						$("#chipArea").append("<span class='chipPrefixClass'>" + chipPrefix + "</span><input style='width:70px;' class='required' type='text' id='"+i+"'  onblur='checkItem("+i+");return false;' name='cardNo'/> &nbsp; &nbsp; &nbsp; &nbsp;");

						if((i+1)%5==0){
							$("#chipArea").append("<br/>")
						}
					}
					var oBtn=document.getElementById('btn')


					oBtn.onclick=function(){

						var aLi=$("#chipArea input");
						var firstInput=aLi[0];
						var firstVal=firstInput.value;
						if(firstVal=="")return;
						firstVal=firstVal.split('')
						var firstVal_length = firstVal.length;
						var arr_0 = [];
						for(var i = 0;i<=firstVal_length;i++){
							if(firstVal[0] != '0'){
								break;
							}else{
								arr_0.push('0')
								firstVal.shift()
							}
						}
						firstVal=firstVal.join('')
						firstVal=parseInt(firstVal)
						for(var i=0;i<aLi.length;i++){
							var a = (firstVal+i)+''
							a = a.split('')
							a = arr_0.concat(a); //补0
							//判断位数是否超过初始长度 去除因递增补位 前面多出来的0
							if(a.length>firstVal_length&&a[0]=='0'){
								var dif = a.length-firstVal_length
								a.splice(0,dif)
							}
							//还原
							a = a.join('')
							aLi[i].value=a;
							checkItem(aLi[i].id);
						}
					}
				}
			}catch(e){
				$("#chipCount").val("");
			}
		}
		//重复芯片验证
		function checkItem(i){
			var code=$("#"+i+"").val();
			var chip= $("input[name='chipPrefix']:checked").val() + code;
			
			if(code!=''){
				$.ajax({
					type:"POST",
					url: ctx+"/sys/orgChip/checkChip",
					data : {'chip':chip},
					dataType: 'json',
					async: false,
					success: function(json){
						if(json.rc==true){
							$.jBox.alert(chip+"此芯片已经存在!","提示");
							$("#"+i+"").val("");
						}
					}
				});
			}
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/org/">合作机构列表</a></li>
		<li class="active"><a href="${ctx}/sys/orgChip/add?orgId=${org.id}">物资录入</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="orgChip" action="${ctx}/sys/orgChip/batchSave" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">合作机构名：</label>
			<div class="controls">
				<form:input path="orgId" type="hidden" htmlEscape="false" maxlength="64" class="input-xlarge required" readonly="true"/>
				<input type="text"  value="${org.name }" class="input-xlarge required" readonly="readonly"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">发放日期：</label>
			<div class="controls">
				<input name="postDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${orgChip.postDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片号段：</label>
			<div class="controls">
				<input name="chipPrefix" type="radio" checked="checked" value="1561000"/>1561000
				<input name="chipPrefix" type="radio" value="900115"/>900115
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片数量：</label>
			<div class="controls">
				<input type="text" name="chipCount" id="chipCount"  maxlength="50" class=" required"  onblur="addItem();return false;" />
				<span class="help-inline"><font color="red">*</font> </span>
				<button id="btn" class="btn btn-primary" type="button" >连号自动输入 </button>
				<div id="chipArea"></div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" maxlength="100" class="input-xlarge " />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">采血器材数量：</label>
			<div class="controls">
				<form:input path="drawBlood" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0" value="0" />
				<span class="help-inline"><font color="red">*同批次取最大值显示</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">采血卡数量：</label>
			<div class="controls">
				<form:input path="bloodCard" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"  value="0"/>
				<span class="help-inline"><font color="red">*同批次取最大值显示</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书数量：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"  value="0"/>
				<span class="help-inline"><font color="red">*同批次取最大值显示</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">玛犬血统证书数量：</label>
			<div class="controls">
				<form:input path="pedigreeCertifiedMc" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"  value="0"/>
				<span class="help-inline"><font color="red">*同批次取最大值显示</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">杜高血统证书数量：</label>
			<div class="controls">
				<form:input path="pedigreeCertifiedDc" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"  value="0"/>
				<span class="help-inline"><font color="red">*同批次取最大值显示</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鉴定证书数量：</label>
			<div class="controls">
				<form:input path="appraisalCertified" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"  value="0"/>
				<span class="help-inline"><font color="red">*同批次取最大值显示</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">DNA血统证书证书数量：</label>
			<div class="controls">
				<form:input path="dnaPedigreeCertified" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"  value="0"/>
				<span class="help-inline"><font color="red">*同批次取最大值显示</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">DNA繁育证书证书数量：</label>
			<div class="controls">
				<form:input path="dnaBreedCertified" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"  value="0"/>
				<span class="help-inline"><font color="red">*同批次取最大值显示</font></span>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="sys:org:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>