<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>消息中心管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/boardcast/baseMessage/SystemMessage">系统消息列表</a></li>
		<shiro:hasPermission name="boardcast:systemMessage:edit"><li><a href="${ctx}/boardcast/baseMessage/SystemMessage/form">系统消息添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="baseMessage" action="${ctx}/boardcast/baseMessage/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>标题：</label>
				<form:input path="title" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>消息的标题</th>
				<th>更新时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="boardcast:systemMessage:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="baseMessage">
			<tr>
				<td><a href="${ctx}/boardcast/baseMessage/SystemMessage/form?id=${baseMessage.id}">
					${baseMessage.title}
				</a></td>
				<td>
					<fmt:formatDate value="${baseMessage.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${baseMessage.remarks}
				</td>
				<shiro:hasPermission name="boardcast:systemMessage:edit"><td>
    				<a href="${ctx}/boardcast/baseMessage/SystemMessage/form?id=${baseMessage.id}">修改</a>
					<a href="${ctx}/boardcast/baseMessage/SystemMessage/delete?id=${baseMessage.id}" onclick="return confirmx('确认要删除该消息中心吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>