<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展场馆管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show/showVenue/">犬展场馆列表</a></li>
		<shiro:hasPermission name="show:showVenue:add"><li><a href="${ctx}/show/showVenue/form">犬展场馆添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showVenue" action="${ctx}/show/showVenue/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>举办地点：</label>
				<form:input path="venueName" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>场馆地址：</label>
				<form:input path="venueAddress" htmlEscape="false" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>举办地点</th>
				<th>场馆地址</th>
				<th>场馆电话</th>
				<th>创建时间</th>
				<th>修改时间</th>
				<th>备注信息</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showVenue">
			<tr>
				<td><a href="${ctx}/show/showVenue/form?id=${showVenue.id}">
					${showVenue.venueName}
				</a></td>
				<td>
					${showVenue.venueAddress}
				</td>
				<td>
					${showVenue.venuePhone}
				</td>
				<td>
					<fmt:formatDate value="${showVenue.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${showVenue.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${showVenue.remarks}
				</td>
				<td>
				<shiro:hasPermission name="show:showVenue:view">
    				<a href="${ctx}/show/showVenue/view?id=${showVenue.id}">查看</a>
    			</shiro:hasPermission>
				<shiro:hasPermission name="show:showVenue:edit">
    				<a href="${ctx}/show/showVenue/form?id=${showVenue.id}">编辑</a>
    			</shiro:hasPermission>
				<shiro:hasPermission name="show:showVenue:delete">
					<a href="${ctx}/show/showVenue/delete?id=${showVenue.id}" onclick="return confirmx('确认要删除该犬展场馆吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>