<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展子表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">犬展列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="mainShows" action="${ctx}/mainShow/CkuShows/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
		<li>
		<label>犬展名称：</label>
				<form:input path="mainShowName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬展地点：</label>
				<form:input path="showLocation" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>主办方：</label>
				<form:select path="organizer" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('show_organizer')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬展名称</th>
				<th>犬展地点</th>
				<th>犬展报名截止时间</th>
				<th>开始日期</th>
				<th>结束日期</th>
				<th>报名</th>
				<th>举办方式</th>
				<th>主办</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="mainShows">
			<tr>
				<td>
					${fns:escapeHtml(mainShows.mainShowName)}
				</td>
				<td>
					${fns:escapeHtml(mainShows.showLocation)}
				</td>
				<td>
					<fmt:formatDate value="${mainShows.closingTime}" pattern="yyyy-MM-dd HH:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${mainShows.startTime}" pattern="yyyy-MM-dd"/> 
				</td>
				<td>
					<fmt:formatDate value="${mainShows.endTime}" pattern="yyyy-MM-dd"/> 
				</td>
				<td>
					${fns:getDictLabel(mainShows.register, 'show_register', '')}
				</td>
				<td>
					${fns:getDictLabel(mainShows.orgnizeType, 'show_orgnize_type', '')}
				</td>
				<td>
					${fns:getDictLabel(mainShows.organizer, 'show_organizer', '')}
				</td>
				<td>
					<shiro:hasPermission name="mainShow:CkuShows:add">
					<a href="${ctx}/mainShow/CkuShows/add?id=${mainShows.id}">编辑</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>